/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.sqlite;

import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import io.requery.android.sqlite.BaseConnection;
import io.requery.android.sqlite.SqliteMetaData;
import io.requery.android.sqlite.SqlitePreparedStatement;
import io.requery.android.sqlite.SqliteStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;

class SqliteConnection
extends BaseConnection {
    private final SQLiteDatabase db;
    private final SqliteMetaData metaData;
    private boolean enteredTransaction;

    SqliteConnection(SQLiteDatabase db) {
        if (db == null) {
            throw new IllegalArgumentException("null db");
        }
        this.db = db;
        this.autoCommit = true;
        this.metaData = new SqliteMetaData(this);
    }

    SQLiteDatabase getDatabase() {
        return this.db;
    }

    @Override
    protected void ensureTransaction() {
        if (!this.autoCommit && !this.db.inTransaction()) {
            this.db.beginTransactionNonExclusive();
            this.enteredTransaction = true;
        }
    }

    @Override
    protected void execSQL(String sql) throws java.sql.SQLException {
        try {
            this.db.execSQL(sql);
        }
        catch (SQLException e) {
            SqliteConnection.throwSQLException(e);
        }
    }

    @Override
    public void commit() throws java.sql.SQLException {
        if (this.autoCommit) {
            throw new java.sql.SQLException("commit called while in autoCommit mode");
        }
        if (this.db.inTransaction() && this.enteredTransaction) {
            try {
                this.db.setTransactionSuccessful();
            }
            catch (IllegalStateException e) {
                throw new java.sql.SQLException(e);
            }
            finally {
                this.db.endTransaction();
                this.enteredTransaction = false;
            }
        }
    }

    @Override
    public Statement createStatement() throws java.sql.SQLException {
        return new SqliteStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws java.sql.SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws java.sql.SQLException {
        if (resultSetConcurrency == 1008) {
            throw new SQLFeatureNotSupportedException("CONCUR_UPDATABLE not supported");
        }
        return new SqliteStatement(this);
    }

    @Override
    public DatabaseMetaData getMetaData() throws java.sql.SQLException {
        return this.metaData;
    }

    @Override
    public boolean isClosed() throws java.sql.SQLException {
        return !this.db.isOpen();
    }

    @Override
    public boolean isReadOnly() throws java.sql.SQLException {
        return this.db.isReadOnly();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws java.sql.SQLException {
        return new SqlitePreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws java.sql.SQLException {
        if (resultSetConcurrency == 1008) {
            throw new SQLFeatureNotSupportedException("CONCUR_UPDATABLE not supported");
        }
        return new SqlitePreparedStatement(this, sql, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws java.sql.SQLException {
        if (columnNames.length != 1) {
            throw new SQLFeatureNotSupportedException();
        }
        return new SqlitePreparedStatement(this, sql, 1);
    }

    @Override
    public void rollback() throws java.sql.SQLException {
        if (this.autoCommit) {
            throw new java.sql.SQLException("commit called while in autoCommit mode");
        }
        this.db.endTransaction();
    }
}

