/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.AbstractSharedListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import io.seata.common.exception.NotSupportYetException;
import io.seata.common.util.StringUtils;
import io.seata.config.AbstractConfiguration;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfiguration
extends AbstractConfiguration {
    private static volatile NacosConfiguration instance;
    private static final Logger LOGGER;
    private static final String DEFAULT_GROUP = "SEATA_GROUP";
    private static final String GROUP_KEY = "group";
    private static final String PRO_SERVER_ADDR_KEY = "serverAddr";
    private static final String ENDPOINT_KEY = "endpoint";
    private static final String CONFIG_TYPE = "nacos";
    private static final String DEFAULT_NAMESPACE = "";
    private static final String PRO_NAMESPACE_KEY = "namespace";
    private static final String USER_NAME = "username";
    private static final String PASSWORD = "password";
    private static final String ACCESS_KEY = "accessKey";
    private static final String SECRET_KEY = "secretKey";
    private static final Configuration FILE_CONFIG;
    private static volatile ConfigService configService;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private ConcurrentMap<String, ConcurrentMap<ConfigurationChangeListener, NacosListener>> configListenersMap = new ConcurrentHashMap<String, ConcurrentMap<ConfigurationChangeListener, NacosListener>>(8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NacosConfiguration getInstance() {
        if (instance != null) return instance;
        Class<NacosConfiguration> clazz = NacosConfiguration.class;
        synchronized (NacosConfiguration.class) {
            if (instance != null) return instance;
            instance = new NacosConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private NacosConfiguration() {
        if (configService == null) {
            try {
                configService = NacosFactory.createConfigService((Properties)NacosConfiguration.getConfigProperties());
            }
            catch (NacosException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public String getLatestConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = this.getConfigFromSysPro(dataId);
        if (value != null) {
            return value;
        }
        try {
            value = configService.getConfig(dataId, NacosConfiguration.getNacosGroup(), timeoutMills);
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return value == null ? defaultValue : value;
    }

    @Override
    public boolean putConfig(String dataId, String content, long timeoutMills) {
        boolean result = false;
        try {
            result = configService.publishConfig(dataId, NacosConfiguration.getNacosGroup(), content);
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return result;
    }

    @Override
    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        throw new NotSupportYetException("not support atomic operation putConfigIfAbsent");
    }

    @Override
    public boolean removeConfig(String dataId, long timeoutMills) {
        boolean result = false;
        try {
            result = configService.removeConfig(dataId, NacosConfiguration.getNacosGroup());
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return result;
    }

    @Override
    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (dataId == null || listener == null) {
            return;
        }
        try {
            this.configListenersMap.putIfAbsent(dataId, new ConcurrentHashMap());
            NacosListener nacosListener = new NacosListener(dataId, listener);
            ((ConcurrentMap)this.configListenersMap.get(dataId)).put(listener, nacosListener);
            configService.addListener(dataId, NacosConfiguration.getNacosGroup(), (Listener)nacosListener);
        }
        catch (Exception exx) {
            LOGGER.error("add nacos listener error:{}", (Object)exx.getMessage(), (Object)exx);
        }
    }

    @Override
    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        Set<ConfigurationChangeListener> configChangeListeners = this.getConfigListeners(dataId);
        if (configChangeListeners == null || listener == null) {
            return;
        }
        for (ConfigurationChangeListener entry : configChangeListeners) {
            if (!listener.equals(entry)) continue;
            NacosListener nacosListener = null;
            if (this.configListenersMap.containsKey(dataId)) {
                nacosListener = (NacosListener)((Object)((ConcurrentMap)this.configListenersMap.get(dataId)).get(listener));
                ((ConcurrentMap)this.configListenersMap.get(dataId)).remove(entry);
            }
            if (nacosListener == null) break;
            configService.removeListener(dataId, NacosConfiguration.getNacosGroup(), nacosListener);
            break;
        }
    }

    @Override
    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        if (this.configListenersMap.containsKey(dataId)) {
            return ((ConcurrentMap)this.configListenersMap.get(dataId)).keySet();
        }
        return null;
    }

    private static Properties getConfigProperties() {
        String userName;
        Properties properties = new Properties();
        if (System.getProperty(ENDPOINT_KEY) != null) {
            properties.setProperty(ENDPOINT_KEY, System.getProperty(ENDPOINT_KEY));
            properties.put(ACCESS_KEY, Objects.toString(System.getProperty(ACCESS_KEY), DEFAULT_NAMESPACE));
            properties.put(SECRET_KEY, Objects.toString(System.getProperty(SECRET_KEY), DEFAULT_NAMESPACE));
        } else if (System.getProperty(PRO_SERVER_ADDR_KEY) != null) {
            properties.setProperty(PRO_SERVER_ADDR_KEY, System.getProperty(PRO_SERVER_ADDR_KEY));
        } else {
            String address = FILE_CONFIG.getConfig(NacosConfiguration.getNacosAddrFileKey());
            if (address != null) {
                properties.setProperty(PRO_SERVER_ADDR_KEY, address);
            }
        }
        if (System.getProperty(PRO_NAMESPACE_KEY) != null) {
            properties.setProperty(PRO_NAMESPACE_KEY, System.getProperty(PRO_NAMESPACE_KEY));
        } else {
            String namespace = FILE_CONFIG.getConfig(NacosConfiguration.getNacosNameSpaceFileKey());
            if (namespace == null) {
                namespace = DEFAULT_NAMESPACE;
            }
            properties.setProperty(PRO_NAMESPACE_KEY, namespace);
        }
        String string = userName = StringUtils.isNotBlank(System.getProperty(USER_NAME)) ? System.getProperty(USER_NAME) : FILE_CONFIG.getConfig(NacosConfiguration.getNacosUserName());
        if (StringUtils.isNotBlank(userName)) {
            String password;
            String string2 = password = StringUtils.isNotBlank(System.getProperty(PASSWORD)) ? System.getProperty(PASSWORD) : FILE_CONFIG.getConfig(NacosConfiguration.getNacosPassword());
            if (StringUtils.isNotBlank(password)) {
                properties.setProperty(USER_NAME, userName);
                properties.setProperty(PASSWORD, password);
            }
        }
        return properties;
    }

    private static String getNacosNameSpaceFileKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, PRO_NAMESPACE_KEY);
    }

    private static String getNacosAddrFileKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, PRO_SERVER_ADDR_KEY);
    }

    private static String getNacosGroupKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, GROUP_KEY);
    }

    private static String getNacosUserName() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, USER_NAME);
    }

    private static String getNacosPassword() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, PASSWORD);
    }

    private static String getNacosGroup() {
        return FILE_CONFIG.getConfig(NacosConfiguration.getNacosGroupKey(), DEFAULT_GROUP);
    }

    @Override
    public String getTypeName() {
        return CONFIG_TYPE;
    }

    static {
        LOGGER = LoggerFactory.getLogger(NacosConfiguration.class);
        FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    }

    public static class NacosListener
    extends AbstractSharedListener {
        private final String dataId;
        private final ConfigurationChangeListener listener;

        public NacosListener(String dataId, ConfigurationChangeListener listener) {
            this.dataId = dataId;
            this.listener = listener;
        }

        public ConfigurationChangeListener getTargetListener() {
            return this.listener;
        }

        public void innerReceive(String dataId, String group, String configInfo) {
            ConfigurationChangeEvent event = new ConfigurationChangeEvent().setDataId(dataId).setNewValue(configInfo).setNamespace(group);
            this.listener.onProcessEvent(event);
        }
    }
}

