/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.parser.utils;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.exception.FrameworkException;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachineInstance;
import io.seata.saga.statelang.parser.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class DesignerJsonTransformer {
    public static Map<String, Object> toStandardJson(Map<String, Object> designerJsonObject) {
        if (!DesignerJsonTransformer.isDesignerJson(designerJsonObject)) {
            return designerJsonObject;
        }
        LinkedHashMap<String, Object> machineJsonObject = new LinkedHashMap<String, Object>();
        List nodes = (List)designerJsonObject.get("nodes");
        if (nodes != null && nodes.size() > 0) {
            LinkedHashMap<String, Object> nodeMap = new LinkedHashMap<String, Object>(nodes.size());
            for (Object node : nodes) {
                Map nodeObj = (Map)node;
                DesignerJsonTransformer.transformNode(machineJsonObject, nodeMap, nodeObj);
            }
            List edges = (List)designerJsonObject.get("edges");
            if (edges != null && edges.size() > 0) {
                for (Object edge : edges) {
                    Map edgeObj = (Map)edge;
                    DesignerJsonTransformer.transformEdge(machineJsonObject, nodes, nodeMap, edgeObj);
                }
            }
        }
        return machineJsonObject;
    }

    private static void transformNode(Map<String, Object> machineJsonObject, Map<String, Object> nodeMap, Map<String, Object> nodeObj) {
        nodeMap.put((String)nodeObj.get("id"), nodeObj);
        String type = (String)nodeObj.get("stateType");
        Map propsObj = (Map)nodeObj.get("stateProps");
        if ("Start".equals(type)) {
            if (propsObj != null && propsObj.containsKey("StateMachine")) {
                machineJsonObject.putAll((Map)propsObj.get("StateMachine"));
            }
        } else if (!"Catch".equals(type)) {
            LinkedHashMap states = (LinkedHashMap)machineJsonObject.get("States");
            if (states == null) {
                states = new LinkedHashMap();
                machineJsonObject.put("States", states);
            }
            LinkedHashMap<String, String> stateJsonObject = new LinkedHashMap<String, String>();
            String stateId = (String)nodeObj.get("stateId");
            if (states.containsKey(stateId)) {
                throw new RuntimeException("Transform designer json to standard json failed, stateId[" + stateId + "] already exists, pls rename it.");
            }
            String comment = (String)nodeObj.get("label");
            if (StringUtils.hasLength((String)comment)) {
                stateJsonObject.put("Comment", comment);
            }
            if (propsObj != null) {
                stateJsonObject.putAll(propsObj);
            }
            states.put(stateId, stateJsonObject);
            String stateType = (String)nodeObj.get("stateType");
            if ("Compensation".equals(stateType)) {
                stateJsonObject.put("Type", "ServiceTask");
            } else {
                stateJsonObject.put("Type", stateType);
            }
        }
    }

    private static void transformEdge(Map<String, Object> machineJsonObject, List<Object> nodes, Map<String, Object> nodeMap, Map<String, Object> edgeObj) {
        String sourceId = (String)edgeObj.get("source");
        String targetId = (String)edgeObj.get("target");
        if (StringUtils.hasLength((String)sourceId)) {
            Map sourceNode = (Map)nodeMap.get(sourceId);
            Map targetNode = (Map)nodeMap.get(targetId);
            if (sourceNode != null) {
                Map states = (Map)machineJsonObject.get("States");
                Map sourceState = (Map)states.get((String)sourceNode.get("stateId"));
                String targetStateId = (String)targetNode.get("stateId");
                String sourceType = (String)sourceNode.get("stateType");
                if ("Start".equals(sourceType)) {
                    machineJsonObject.put("StartState", targetStateId);
                    machineJsonObject.put("States", machineJsonObject.remove("States"));
                } else if ("ServiceTask".equals(sourceType)) {
                    if (targetNode != null && "Compensation".equals(targetNode.get("stateType"))) {
                        sourceState.put("CompensateState", targetStateId);
                    } else {
                        sourceState.put("Next", targetStateId);
                    }
                } else if ("Catch".equals(sourceType)) {
                    Map edgeProps;
                    Map<String, Object> catchAttachedNode = DesignerJsonTransformer.getCatchAttachedNode(sourceNode, nodes);
                    if (catchAttachedNode == null) {
                        throw new RuntimeException("'Catch' node[" + sourceNode.get("id") + "] is not attached on a 'ServiceTask' or 'ScriptTask'");
                    }
                    Map catchAttachedState = (Map)states.get(catchAttachedNode.get("stateId"));
                    ArrayList catches = (ArrayList)catchAttachedState.get("Catch");
                    if (catches == null) {
                        catches = new ArrayList();
                        catchAttachedState.put("Catch", catches);
                    }
                    if ((edgeProps = (Map)edgeObj.get("stateProps")) != null) {
                        LinkedHashMap catchObj = new LinkedHashMap();
                        catchObj.put("Exceptions", edgeProps.get("Exceptions"));
                        catchObj.put("Next", targetStateId);
                        catches.add(catchObj);
                    }
                } else if ("Choice".equals(sourceType)) {
                    Map edgeProps;
                    ArrayList choices = (ArrayList)sourceState.get("Choices");
                    if (choices == null) {
                        choices = new ArrayList();
                        sourceState.put("Choices", choices);
                    }
                    if ((edgeProps = (Map)edgeObj.get("stateProps")) != null) {
                        if (Boolean.TRUE.equals(edgeProps.get("Default"))) {
                            sourceState.put("Default", targetStateId);
                        } else {
                            LinkedHashMap choiceObj = new LinkedHashMap();
                            choiceObj.put("Expression", edgeProps.get("Expression"));
                            choiceObj.put("Next", targetStateId);
                            choices.add(choiceObj);
                        }
                    }
                } else {
                    sourceState.put("Next", targetStateId);
                }
            }
        }
    }

    public static boolean isDesignerJson(Map<String, Object> jsonObject) {
        return jsonObject != null && jsonObject.containsKey("nodes") && jsonObject.containsKey("edges");
    }

    private static Map<String, Object> getCatchAttachedNode(Map<String, Object> catchNode, List<Object> nodes) {
        Number catchNodeX = (Number)catchNode.get("x");
        Number catchNodeY = (Number)catchNode.get("y");
        String catchSize = (String)catchNode.get("size");
        String[] catchSizes = catchSize.split("\\*");
        int catchWidth = Integer.parseInt(catchSizes[0]);
        int catchHeight = Integer.parseInt(catchSizes[1]);
        for (Object node : nodes) {
            Map nodeObj = (Map)node;
            if (catchNode == nodeObj || !"ServiceTask".equals(nodeObj.get("stateType")) && !"ScriptTask".equals(nodeObj.get("stateType"))) continue;
            Number nodeX = (Number)nodeObj.get("x");
            Number nodeY = (Number)nodeObj.get("y");
            String nodeSize = (String)nodeObj.get("size");
            String[] nodeSizes = nodeSize.split("\\*");
            int nodeWidth = Integer.parseInt(nodeSizes[0]);
            int nodeHeight = Integer.parseInt(nodeSizes[1]);
            if (!DesignerJsonTransformer.isBordersCoincided(catchNodeX, nodeX, catchWidth, nodeWidth) || !DesignerJsonTransformer.isBordersCoincided(catchNodeY, nodeY, catchHeight, nodeHeight)) continue;
            return nodeObj;
        }
        return null;
    }

    private static boolean isBordersCoincided(Number xyA, Number xyB, Number lengthA, Number lengthB) {
        double centerPointLength = xyA.doubleValue() > xyB.doubleValue() ? xyA.doubleValue() - xyB.doubleValue() : xyB.doubleValue() - xyA.doubleValue();
        return (lengthA.doubleValue() + lengthB.doubleValue()) / 2.0 > centerPointLength;
    }

    public static String generateTracingGraphJson(StateMachineInstance stateMachineInstance, JsonParser jsonParser) {
        if (stateMachineInstance == null) {
            throw new FrameworkException("StateMachineInstance is not exits", FrameworkErrorCode.StateMachineInstanceNotExists);
        }
        String stateMachineJson = stateMachineInstance.getStateMachine().getContent();
        if (StringUtils.isEmpty((Object)stateMachineJson)) {
            throw new FrameworkException("Cannot get StateMachine Json", FrameworkErrorCode.ObjectNotExists);
        }
        Map stateMachineJsonObj = jsonParser.parse(stateMachineJson, Map.class, true);
        if (!DesignerJsonTransformer.isDesignerJson(stateMachineJsonObj)) {
            throw new FrameworkException("StateMachine Json is not generated by Designer", FrameworkErrorCode.InvalidConfiguration);
        }
        HashMap<String, ArrayList<StateInstance>> stateInstanceMapGroupByName = new HashMap<String, ArrayList<StateInstance>>(stateMachineInstance.getStateMap().size());
        for (String id : stateMachineInstance.getStateMap().keySet()) {
            StateInstance stateInstance = stateMachineInstance.getStateMap().get(id);
            ArrayList<StateInstance> stateInstanceList = (ArrayList<StateInstance>)stateInstanceMapGroupByName.get(stateInstance.getName());
            if (stateInstanceList == null) {
                stateInstanceList = new ArrayList<StateInstance>();
                stateInstanceMapGroupByName.put(stateInstance.getName(), stateInstanceList);
            }
            stateInstanceList.add(stateInstance);
        }
        List nodesArray = (List)stateMachineJsonObj.get("nodes");
        for (Object nodeObj : nodesArray) {
            LinkedHashMap<String, Object> style;
            List stateInstanceList;
            Map node = (Map)nodeObj;
            String stateId = (String)node.get("stateId");
            String stateType = (String)node.get("stateType");
            if ("ServiceTask".equals(stateType) || "SubStateMachine".equals(stateType) || "Compensation".equals(stateType)) {
                node.remove("color");
            }
            if ((stateInstanceList = (List)stateInstanceMapGroupByName.get(stateId)) == null || stateInstanceList.size() <= 0) continue;
            StateInstance stateInstance = null;
            if (stateInstanceList.size() == 1) {
                stateInstance = (StateInstance)stateInstanceList.get(0);
            } else {
                for (StateInstance stateInst : stateInstanceList) {
                    if (stateInstance != null && !stateInst.getGmtStarted().after(stateInstance.getGmtStarted())) continue;
                    stateInstance = stateInst;
                }
            }
            node.put("stateInstanceId", stateInstance.getId());
            node.put("stateInstanceStatus", stateInstance.getStatus());
            if (ExecutionStatus.SU.equals((Object)stateInstance.getStatus())) {
                node.put("color", "green");
                style = new LinkedHashMap<String, Object>();
                style.put("fill", "#00D73E");
                style.put("lineWidth", 2);
                node.put("style", style);
                continue;
            }
            node.put("color", "red");
            style = new LinkedHashMap();
            style.put("fill", "#FF7777");
            style.put("lineWidth", 2);
            node.put("style", style);
        }
        if (stateMachineJsonObj != null) {
            return jsonParser.toJsonString(stateMachineJsonObj, true);
        }
        return "";
    }
}

