/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.processor.client;

import io.netty.channel.ChannelHandlerContext;
import io.seata.core.protocol.AbstractResultMessage;
import io.seata.core.protocol.BatchResultMessage;
import io.seata.core.protocol.MergeMessage;
import io.seata.core.protocol.MergeResultMessage;
import io.seata.core.protocol.MergedWarpMessage;
import io.seata.core.protocol.MessageFuture;
import io.seata.core.protocol.RpcMessage;
import io.seata.core.rpc.TransactionMessageHandler;
import io.seata.core.rpc.processor.RemotingProcessor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientOnResponseProcessor
implements RemotingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientOnResponseProcessor.class);
    private Map<Integer, MergeMessage> mergeMsgMap;
    private final ConcurrentMap<Integer, MessageFuture> futures;
    private final TransactionMessageHandler transactionMessageHandler;

    public ClientOnResponseProcessor(Map<Integer, MergeMessage> mergeMsgMap, ConcurrentHashMap<Integer, MessageFuture> futures, TransactionMessageHandler transactionMessageHandler) {
        this.mergeMsgMap = mergeMsgMap;
        this.futures = futures;
        this.transactionMessageHandler = transactionMessageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ChannelHandlerContext ctx, RpcMessage rpcMessage) throws Exception {
        if (rpcMessage.getBody() instanceof MergeResultMessage) {
            MergeResultMessage results = (MergeResultMessage)rpcMessage.getBody();
            MergedWarpMessage mergeMessage = (MergedWarpMessage)this.mergeMsgMap.remove(rpcMessage.getId());
            for (int i = 0; i < mergeMessage.msgs.size(); ++i) {
                int msgId = mergeMessage.msgIds.get(i);
                MessageFuture future = (MessageFuture)this.futures.remove(msgId);
                if (future == null) {
                    LOGGER.error("msg: {} is not found in futures, result message: {}", (Object)msgId, (Object)results.getMsgs()[i]);
                    continue;
                }
                future.setResultMessage(results.getMsgs()[i]);
            }
        } else if (rpcMessage.getBody() instanceof BatchResultMessage) {
            try {
                BatchResultMessage batchResultMessage = (BatchResultMessage)rpcMessage.getBody();
                for (int i = 0; i < batchResultMessage.getMsgIds().size(); ++i) {
                    int msgId = batchResultMessage.getMsgIds().get(i);
                    MessageFuture future = (MessageFuture)this.futures.remove(msgId);
                    if (future == null) {
                        LOGGER.error("msg: {} is not found in futures, result message: {}", (Object)msgId, (Object)batchResultMessage.getResultMessages().get(i));
                        continue;
                    }
                    future.setResultMessage(batchResultMessage.getResultMessages().get(i));
                }
            }
            finally {
                this.mergeMsgMap.clear();
            }
        } else {
            MessageFuture messageFuture = (MessageFuture)this.futures.remove(rpcMessage.getId());
            if (messageFuture != null) {
                messageFuture.setResultMessage(rpcMessage.getBody());
            } else if (rpcMessage.getBody() instanceof AbstractResultMessage && this.transactionMessageHandler != null) {
                this.transactionMessageHandler.onResponse((AbstractResultMessage)rpcMessage.getBody(), null);
            }
        }
    }
}

