/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.tx.api.interceptor.parser;

import io.seata.common.util.CollectionUtils;
import io.seata.config.ConfigurationCache;
import io.seata.integration.tx.api.interceptor.handler.GlobalTransactionalInterceptorHandler;
import io.seata.integration.tx.api.interceptor.handler.ProxyInvocationHandler;
import io.seata.integration.tx.api.interceptor.parser.DefaultTargetClassParser;
import io.seata.integration.tx.api.interceptor.parser.InterfaceParser;
import io.seata.spring.annotation.GlobalLock;
import io.seata.spring.annotation.GlobalTransactional;
import io.seata.tm.api.FailureHandlerHolder;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class GlobalTransactionalInterceptorParser
implements InterfaceParser {
    private final Set<String> methodsToProxy = new HashSet<String>();

    @Override
    public ProxyInvocationHandler parserInterfaceToProxy(Object target, String objectName) throws Exception {
        Class<?> serviceInterface = DefaultTargetClassParser.get().findTargetClass(target);
        Class<?>[] interfacesIfJdk = DefaultTargetClassParser.get().findInterfaces(target);
        if (this.existsAnnotation(serviceInterface) || this.existsAnnotation(interfacesIfJdk)) {
            GlobalTransactionalInterceptorHandler proxyInvocationHandler = new GlobalTransactionalInterceptorHandler(FailureHandlerHolder.getFailureHandler(), this.methodsToProxy);
            ConfigurationCache.addConfigListener("service.disableGlobalTransaction", proxyInvocationHandler);
            return proxyInvocationHandler;
        }
        return null;
    }

    private boolean existsAnnotation(Class<?> ... classes) {
        boolean result = false;
        if (CollectionUtils.isNotEmpty(classes)) {
            for (Class<?> clazz : classes) {
                Method[] methods;
                if (clazz == null) continue;
                GlobalTransactional trxAnno = clazz.getAnnotation(GlobalTransactional.class);
                if (trxAnno != null) {
                    return true;
                }
                for (Method method : methods = clazz.getMethods()) {
                    GlobalLock lockAnno;
                    trxAnno = method.getAnnotation(GlobalTransactional.class);
                    if (trxAnno != null) {
                        this.methodsToProxy.add(method.getName());
                        result = true;
                    }
                    if ((lockAnno = method.getAnnotation(GlobalLock.class)) == null) continue;
                    this.methodsToProxy.add(method.getName());
                    result = true;
                }
            }
        }
        return result;
    }
}

