/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.interceptor;

import io.seata.common.holder.ObjectHolder;
import io.seata.common.util.ReflectionUtil;
import io.seata.config.ConfigurationFactory;
import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import io.seata.integration.tx.api.fence.config.CommonFenceConfig;
import io.seata.integration.tx.api.interceptor.ActionInterceptorHandler;
import io.seata.integration.tx.api.interceptor.InvocationWrapper;
import io.seata.integration.tx.api.interceptor.SeataInterceptorPosition;
import io.seata.integration.tx.api.interceptor.TwoPhaseBusinessActionParam;
import io.seata.integration.tx.api.interceptor.handler.AbstractProxyInvocationHandler;
import io.seata.integration.tx.api.remoting.RemotingDesc;
import io.seata.rm.tcc.api.TwoPhaseBusinessAction;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.MDC;

public class TccActionInterceptorHandler
extends AbstractProxyInvocationHandler {
    private static final int ORDER_NUM = ConfigurationFactory.getInstance().getInt("client.rm.tccActionInterceptorOrder", -2147482648);
    private ActionInterceptorHandler actionInterceptorHandler = new ActionInterceptorHandler();
    private Set<String> methodsToProxy;
    private RemotingDesc remotingDesc;
    private Map<Method, TwoPhaseBusinessAction> parseAnnotationCache = new ConcurrentHashMap<Method, TwoPhaseBusinessAction>();

    public TccActionInterceptorHandler(RemotingDesc remotingDesc, Set<String> methodsToProxy) {
        this.remotingDesc = remotingDesc;
        this.methodsToProxy = methodsToProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doInvoke(InvocationWrapper invocation) throws Throwable {
        if (!RootContext.inGlobalTransaction() || RootContext.inSagaBranch()) {
            return invocation.proceed();
        }
        Method method = invocation.getMethod();
        TwoPhaseBusinessAction businessAction = this.parseAnnotation(method);
        if (businessAction != null) {
            String xid = RootContext.getXID();
            BranchType previousBranchType = RootContext.getBranchType();
            if (BranchType.TCC != previousBranchType) {
                RootContext.bindBranchType(BranchType.TCC);
            }
            try {
                TwoPhaseBusinessActionParam businessActionParam = new TwoPhaseBusinessActionParam();
                businessActionParam.setActionName(businessAction.name());
                businessActionParam.setDelayReport(businessAction.isDelayReport());
                businessActionParam.setUseCommonFence(businessAction.useTCCFence());
                businessActionParam.setBranchType(BranchType.TCC);
                HashMap<String, Object> businessActionContextMap = new HashMap<String, Object>(4);
                businessActionContextMap.put("sys::commit", businessAction.commitMethod());
                businessActionContextMap.put("sys::rollback", businessAction.rollbackMethod());
                businessActionContextMap.put("actionName", businessAction.name());
                businessActionContextMap.put("useTCCFence", businessAction.useTCCFence());
                businessActionParam.setBusinessActionContext(businessActionContextMap);
                Object object = this.actionInterceptorHandler.proceed(method, invocation.getArguments(), xid, businessActionParam, invocation::proceed);
                return object;
            }
            finally {
                if (BranchType.TCC != previousBranchType) {
                    RootContext.unbindBranchType();
                }
                MDC.remove((String)"X-TX-BRANCH-ID");
            }
        }
        return invocation.proceed();
    }

    private TwoPhaseBusinessAction parseAnnotation(Method methodKey) throws NoSuchMethodException {
        TwoPhaseBusinessAction result = this.parseAnnotationCache.computeIfAbsent(methodKey, method -> {
            Set<Class<?>> interfaceClasses;
            TwoPhaseBusinessAction businessAction = method.getAnnotation(TwoPhaseBusinessAction.class);
            if (businessAction == null && this.remotingDesc.getServiceClass() != null && (interfaceClasses = ReflectionUtil.getInterfaces(this.remotingDesc.getServiceClass())) != null) {
                for (Class<?> interClass : interfaceClasses) {
                    try {
                        Method m = interClass.getMethod(method.getName(), method.getParameterTypes());
                        businessAction = m.getAnnotation(TwoPhaseBusinessAction.class);
                        if (businessAction == null) continue;
                        this.initCommonFenceCleanTask(businessAction);
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return businessAction;
        });
        return result;
    }

    private void initCommonFenceCleanTask(TwoPhaseBusinessAction twoPhaseBusinessAction) {
        CommonFenceConfig commonFenceConfig = (CommonFenceConfig)ObjectHolder.INSTANCE.getObject("SpringFenceConfig");
        if (commonFenceConfig == null || commonFenceConfig.getInitialized().get()) {
            return;
        }
        if (twoPhaseBusinessAction != null && twoPhaseBusinessAction.useTCCFence() && commonFenceConfig.getInitialized().compareAndSet(false, true)) {
            commonFenceConfig.init();
        }
    }

    @Override
    public Set<String> getMethodsToProxy() {
        return this.methodsToProxy;
    }

    @Override
    public int getOrder() {
        return ORDER_NUM;
    }

    @Override
    public SeataInterceptorPosition getPosition() {
        return SeataInterceptorPosition.Any;
    }
}

