/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.annotation.scannercheckers;

import io.seata.common.loader.LoadLevel;
import io.seata.spring.annotation.ScannerChecker;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

@LoadLevel(name="Packages", order=100)
public class PackageScannerChecker
implements ScannerChecker {
    private static final Set<String> SCANNABLE_PACKAGE_SET = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addScannablePackages(String ... packages) {
        if (ArrayUtils.isNotEmpty((Object[])packages)) {
            Set<String> set = SCANNABLE_PACKAGE_SET;
            synchronized (set) {
                for (String pkg : packages) {
                    if (!StringUtils.isNotBlank((String)pkg)) continue;
                    SCANNABLE_PACKAGE_SET.add(pkg.trim().toLowerCase());
                }
            }
        }
    }

    @Override
    public boolean check(Object bean, String beanName, @Nullable ConfigurableListableBeanFactory beanFactory) throws Exception {
        if (SCANNABLE_PACKAGE_SET.isEmpty()) {
            return true;
        }
        String className = bean.getClass().getName();
        for (String pkg : SCANNABLE_PACKAGE_SET) {
            if (!className.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }
}

