/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.config.archaius.sources;

import io.servicecomb.config.archaius.sources.ConfigModel;
import io.servicecomb.config.archaius.sources.YAMLConfigLoader;
import io.servicecomb.foundation.common.exceptions.ServiceCombException;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MicroserviceConfigLoader
extends YAMLConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceConfigLoader.class);
    private static final String ADDITIONAL_CONFIG_URL = "cse.configurationSource.additionalUrls";
    private static final String DEFAULT_CONFIG_FILE_NAME = "microservice.yaml";

    public MicroserviceConfigLoader() {
        this.setOrderKey("cse-config-order");
    }

    public void loadAndSort() {
        try {
            String configFileFromClasspath = System.getProperty("cse.configurationSource.defaultFileName") == null ? DEFAULT_CONFIG_FILE_NAME : System.getProperty("cse.configurationSource.defaultFileName");
            super.load(configFileFromClasspath);
            this.loadAdditionalConfig();
            if (this.configModels.isEmpty()) {
                LOGGER.warn("No URLs will be polled as dynamic configuration sources.");
                LOGGER.warn("To enable URLs as dynamic configuration sources, define System property {} or make {} available on classpath.", (Object)ADDITIONAL_CONFIG_URL, (Object)configFileFromClasspath);
            }
            this.sort();
        }
        catch (IOException e) {
            throw new ServiceCombException("Failed to load microservice config", (Throwable)e);
        }
    }

    private void loadAdditionalConfig() throws IOException {
        String strUrls = System.getProperty(ADDITIONAL_CONFIG_URL);
        if (StringUtils.isEmpty((Object)strUrls)) {
            return;
        }
        for (String strUrl : strUrls.split(",")) {
            URL url = new URL(strUrl);
            ConfigModel configModel = this.load(url);
            this.configModels.add(configModel);
        }
    }
}

