/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.handler.impl;

import io.servicecomb.core.Endpoint;
import io.servicecomb.core.Handler;
import io.servicecomb.core.Invocation;
import io.servicecomb.core.exception.ExceptionUtils;
import io.servicecomb.core.filter.EndpointDiscoveryFilter;
import io.servicecomb.serviceregistry.discovery.DiscoveryContext;
import io.servicecomb.serviceregistry.discovery.DiscoveryFilter;
import io.servicecomb.serviceregistry.discovery.DiscoveryTree;
import io.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;
import io.servicecomb.swagger.invocation.AsyncResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLoadBalanceHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleLoadBalanceHandler.class);
    private DiscoveryTree discoveryTree = new DiscoveryTree();
    private volatile Map<String, AtomicInteger> indexMap = new ConcurrentHashMap<String, AtomicInteger>();

    public SimpleLoadBalanceHandler() {
        this.discoveryTree.loadFromSPI(DiscoveryFilter.class);
        this.discoveryTree.addFilter((DiscoveryFilter)new EndpointDiscoveryFilter());
        this.discoveryTree.sort();
    }

    @Override
    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        DiscoveryContext context = new DiscoveryContext();
        context.setInputParameters((Object)invocation);
        DiscoveryTreeNode endpointsVersionedCache = this.discoveryTree.discovery(context, invocation.getAppId(), invocation.getMicroserviceName(), invocation.getMicroserviceVersionRule());
        if (endpointsVersionedCache.isEmpty()) {
            asyncResp.consumerFail((Throwable)ExceptionUtils.lbAddressNotFound(invocation.getMicroserviceName(), invocation.getMicroserviceVersionRule(), endpointsVersionedCache.name()));
            return;
        }
        List endpoints = (List)endpointsVersionedCache.data();
        AtomicInteger index = this.indexMap.computeIfAbsent(endpointsVersionedCache.name(), name -> {
            LOGGER.info("Create loadBalancer for {}.", name);
            return new AtomicInteger();
        });
        LOGGER.debug("invocation {} use discoveryGroup {}.", (Object)invocation.getMicroserviceQualifiedName(), (Object)endpointsVersionedCache.name());
        int idx = Math.abs(index.getAndIncrement());
        Endpoint endpoint = (Endpoint)endpoints.get(idx %= endpoints.size());
        invocation.setEndpoint(endpoint);
        invocation.next(asyncResp);
    }
}

