/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.orchestration.api;

import io.shardingsphere.api.config.rule.ShardingRuleConfiguration;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.orchestration.config.OrchestrationConfiguration;
import io.shardingsphere.shardingjdbc.jdbc.core.datasource.ShardingDataSource;
import io.shardingsphere.shardingjdbc.orchestration.internal.datasource.OrchestrationShardingDataSource;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public final class OrchestrationShardingDataSourceFactory {
    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, ShardingRuleConfiguration shardingRuleConfig, Map<String, Object> configMap, Properties props, OrchestrationConfiguration orchestrationConfig) throws SQLException {
        if (null == shardingRuleConfig || shardingRuleConfig.getTableRuleConfigs().isEmpty()) {
            return OrchestrationShardingDataSourceFactory.createDataSource(orchestrationConfig);
        }
        ShardingDataSource shardingDataSource = new ShardingDataSource(dataSourceMap, new ShardingRule(shardingRuleConfig, dataSourceMap.keySet()), configMap, props);
        return new OrchestrationShardingDataSource(shardingDataSource, orchestrationConfig);
    }

    public static DataSource createDataSource(OrchestrationConfiguration orchestrationConfig) throws SQLException {
        return new OrchestrationShardingDataSource(orchestrationConfig);
    }

    private OrchestrationShardingDataSourceFactory() {
    }
}

