/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.orchestration.internal.datasource;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import io.shardingsphere.orchestration.internal.eventbus.ShardingOrchestrationEventBus;
import io.shardingsphere.orchestration.internal.registry.ShardingOrchestrationFacade;
import io.shardingsphere.orchestration.internal.registry.state.event.CircuitStateChangedEvent;
import io.shardingsphere.shardingjdbc.jdbc.adapter.AbstractDataSourceAdapter;
import io.shardingsphere.shardingjdbc.orchestration.internal.util.DataSourceConverter;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;

public abstract class AbstractOrchestrationDataSource
extends AbstractDataSourceAdapter {
    private final EventBus eventBus = ShardingOrchestrationEventBus.getInstance();
    private final ShardingOrchestrationFacade shardingOrchestrationFacade;
    private boolean isCircuitBreak;

    public AbstractOrchestrationDataSource(ShardingOrchestrationFacade shardingOrchestrationFacade, Map<String, DataSource> dataSourceMap) throws SQLException {
        super(dataSourceMap);
        this.shardingOrchestrationFacade = shardingOrchestrationFacade;
        this.eventBus.register((Object)this);
    }

    public AbstractOrchestrationDataSource(ShardingOrchestrationFacade shardingOrchestrationFacade) throws SQLException {
        super(DataSourceConverter.getDataSourceMap(shardingOrchestrationFacade.getConfigService().loadDataSourceConfigurations("logic_db")));
        this.shardingOrchestrationFacade = shardingOrchestrationFacade;
        this.eventBus.register((Object)this);
    }

    @Subscribe
    public final synchronized void renew(CircuitStateChangedEvent circuitStateChangedEvent) {
        this.isCircuitBreak = circuitStateChangedEvent.isCircuitBreak();
    }

    protected EventBus getEventBus() {
        return this.eventBus;
    }

    protected ShardingOrchestrationFacade getShardingOrchestrationFacade() {
        return this.shardingOrchestrationFacade;
    }

    protected boolean isCircuitBreak() {
        return this.isCircuitBreak;
    }
}

