/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.orchestration.internal.datasource;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import io.shardingsphere.api.ConfigMapContext;
import io.shardingsphere.api.config.rule.RuleConfiguration;
import io.shardingsphere.api.config.rule.ShardingRuleConfiguration;
import io.shardingsphere.core.rule.MasterSlaveRule;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.orchestration.config.OrchestrationConfiguration;
import io.shardingsphere.orchestration.internal.registry.ShardingOrchestrationFacade;
import io.shardingsphere.orchestration.internal.registry.config.event.ConfigMapChangedEvent;
import io.shardingsphere.orchestration.internal.registry.config.event.DataSourceChangedEvent;
import io.shardingsphere.orchestration.internal.registry.config.event.PropertiesChangedEvent;
import io.shardingsphere.orchestration.internal.registry.config.event.ShardingRuleChangedEvent;
import io.shardingsphere.orchestration.internal.registry.config.service.ConfigurationService;
import io.shardingsphere.orchestration.internal.registry.state.event.DisabledStateChangedEvent;
import io.shardingsphere.orchestration.internal.registry.state.schema.OrchestrationShardingSchema;
import io.shardingsphere.orchestration.internal.rule.OrchestrationMasterSlaveRule;
import io.shardingsphere.orchestration.internal.rule.OrchestrationShardingRule;
import io.shardingsphere.shardingjdbc.jdbc.core.datasource.ShardingDataSource;
import io.shardingsphere.shardingjdbc.orchestration.internal.circuit.datasource.CircuitBreakerDataSource;
import io.shardingsphere.shardingjdbc.orchestration.internal.datasource.AbstractOrchestrationDataSource;
import io.shardingsphere.shardingjdbc.orchestration.internal.util.DataSourceConverter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class OrchestrationShardingDataSource
extends AbstractOrchestrationDataSource {
    private ShardingDataSource dataSource;

    public OrchestrationShardingDataSource(OrchestrationConfiguration orchestrationConfig) throws SQLException {
        super(new ShardingOrchestrationFacade(orchestrationConfig, Collections.singletonList("logic_db")));
        ConfigurationService configService = this.getShardingOrchestrationFacade().getConfigService();
        ShardingRuleConfiguration shardingRuleConfig = configService.loadShardingRuleConfiguration("logic_db");
        Preconditions.checkState((null != shardingRuleConfig && !shardingRuleConfig.getTableRuleConfigs().isEmpty() ? 1 : 0) != 0, (Object)"Missing the sharding rule configuration on registry center");
        this.dataSource = new ShardingDataSource(DataSourceConverter.getDataSourceMap(configService.loadDataSourceConfigurations("logic_db")), (ShardingRule)new OrchestrationShardingRule(shardingRuleConfig, configService.loadDataSourceConfigurations("logic_db").keySet()), configService.loadConfigMap(), configService.loadProperties());
        this.getShardingOrchestrationFacade().init();
    }

    public OrchestrationShardingDataSource(ShardingDataSource shardingDataSource, OrchestrationConfiguration orchestrationConfig) throws SQLException {
        super(new ShardingOrchestrationFacade(orchestrationConfig, Collections.singletonList("logic_db")), shardingDataSource.getDataSourceMap());
        this.dataSource = new ShardingDataSource(shardingDataSource.getDataSourceMap(), (ShardingRule)new OrchestrationShardingRule(shardingDataSource.getShardingContext().getShardingRule().getShardingRuleConfig(), shardingDataSource.getDataSourceMap().keySet()), ConfigMapContext.getInstance().getConfigMap(), shardingDataSource.getShardingContext().getShardingProperties().getProps());
        this.getShardingOrchestrationFacade().init(Collections.singletonMap("logic_db", DataSourceConverter.getDataSourceConfigurationMap(this.dataSource.getDataSourceMap())), this.getRuleConfigurationMap(), null, ConfigMapContext.getInstance().getConfigMap(), this.dataSource.getShardingContext().getShardingProperties().getProps());
    }

    private Map<String, RuleConfiguration> getRuleConfigurationMap() {
        LinkedHashMap<String, RuleConfiguration> ruleConfigurationMap = new LinkedHashMap<String, RuleConfiguration>();
        ruleConfigurationMap.put("logic_db", (RuleConfiguration)this.dataSource.getShardingContext().getShardingRule().getShardingRuleConfig());
        return ruleConfigurationMap;
    }

    public final Connection getConnection() {
        return this.isCircuitBreak() ? new CircuitBreakerDataSource().getConnection() : this.dataSource.getConnection();
    }

    public final void close() {
        this.dataSource.close();
        this.getShardingOrchestrationFacade().close();
    }

    @Subscribe
    public final synchronized void renew(ShardingRuleChangedEvent shardingRuleChangedEvent) {
        this.dataSource = new ShardingDataSource(this.dataSource.getDataSourceMap(), new ShardingRule(shardingRuleChangedEvent.getShardingRuleConfiguration(), this.dataSource.getDataSourceMap().keySet()), ConfigMapContext.getInstance().getConfigMap(), this.dataSource.getShardingContext().getShardingProperties().getProps());
    }

    @Subscribe
    public final synchronized void renew(DataSourceChangedEvent dataSourceChangedEvent) {
        this.dataSource.close();
        this.dataSource = new ShardingDataSource(DataSourceConverter.getDataSourceMap(dataSourceChangedEvent.getDataSourceConfigurations()), this.dataSource.getShardingContext().getShardingRule(), ConfigMapContext.getInstance().getConfigMap(), this.dataSource.getShardingContext().getShardingProperties().getProps());
    }

    @Subscribe
    public final synchronized void renew(PropertiesChangedEvent propertiesChangedEvent) {
        this.dataSource = new ShardingDataSource(this.dataSource.getDataSourceMap(), this.dataSource.getShardingContext().getShardingRule(), ConfigMapContext.getInstance().getConfigMap(), propertiesChangedEvent.getProps());
    }

    @Subscribe
    public final synchronized void renew(ConfigMapChangedEvent configMapChangedEvent) {
        ConfigMapContext.getInstance().getConfigMap().clear();
        ConfigMapContext.getInstance().getConfigMap().putAll(configMapChangedEvent.getConfigMap());
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent disabledStateChangedEvent) {
        OrchestrationShardingSchema shardingSchema = disabledStateChangedEvent.getShardingSchema();
        if ("logic_db".equals(shardingSchema.getSchemaName())) {
            for (MasterSlaveRule each : this.dataSource.getShardingContext().getShardingRule().getMasterSlaveRules()) {
                ((OrchestrationMasterSlaveRule)each).updateDisabledDataSourceNames(shardingSchema.getDataSourceName(), disabledStateChangedEvent.isDisabled());
            }
        }
    }
}

