/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.aspect;

import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.transaction.ShardingEnvironment;
import io.shardingsphere.transaction.annotation.ShardingTransactionType;
import io.shardingsphere.transaction.api.TransactionType;
import io.shardingsphere.transaction.api.TransactionTypeHolder;
import io.shardingsphere.transaction.handler.DataSourceTransactionManagerHandler;
import io.shardingsphere.transaction.handler.JpaTransactionManagerHandler;
import io.shardingsphere.transaction.handler.TransactionManagerHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Aspect
@Component
@Order(value=0x7FFFFFFE)
public final class ShardingTransactionalAspect {
    private static final String PROXY_TAG = "Sharding-Proxy";
    private TransactionManagerHandler transactionManagerHandler;
    private ShardingEnvironment environment;

    @Autowired
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.setTransactionManagerHandler(transactionManager);
    }

    @Autowired
    public void setEnvironment(DataSource[] dataSources) {
        this.environment = null != dataSources && this.isConnectToProxy(dataSources) ? ShardingEnvironment.PROXY : ShardingEnvironment.JDBC;
    }

    @Pointcut(value="@annotation(io.shardingsphere.transaction.annotation.ShardingTransactionType) || @within(io.shardingsphere.transaction.annotation.ShardingTransactionType)")
    public void shardingTransactionalPointCut() {
    }

    @Before(value="shardingTransactionalPointCut()")
    public void setTransactionTypeBeforeTransaction(JoinPoint joinPoint) {
        ShardingTransactionType shardingTransactionType = this.getAnnotation(joinPoint);
        switch (this.environment) {
            case JDBC: {
                TransactionTypeHolder.set((TransactionType)shardingTransactionType.value());
                break;
            }
            case PROXY: {
                this.transactionManagerHandler.switchTransactionType(shardingTransactionType.value());
                break;
            }
        }
    }

    @After(value="shardingTransactionalPointCut()")
    public void cleanTransactionTypeAfterTransaction(JoinPoint joinPoint) {
        switch (this.environment) {
            case JDBC: {
                TransactionTypeHolder.clear();
                break;
            }
            case PROXY: {
                this.transactionManagerHandler.unbindResource();
                break;
            }
        }
    }

    private void setTransactionManagerHandler(PlatformTransactionManager transactionManager) {
        switch (TransactionManagerType.getTransactionManagerTypeByClassName(transactionManager.getClass().getName())) {
            case DATASOURCE: {
                this.transactionManagerHandler = new DataSourceTransactionManagerHandler(transactionManager);
                break;
            }
            case JPA: {
                this.transactionManagerHandler = new JpaTransactionManagerHandler(transactionManager);
                break;
            }
            default: {
                throw new ShardingException(String.format("Switching transaction Type is unsupported for transaction manager %s", transactionManager.getClass().getName()), new Object[0]);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isConnectToProxy(DataSource[] dataSources) {
        DataSource[] dataSourceArray = dataSources;
        int n = dataSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataSource each = dataSourceArray[n2];
            try (Connection connection = each.getConnection();){
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                if (databaseMetaData.getDatabaseProductVersion().contains(PROXY_TAG)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (SQLException ex) {
                throw new ShardingException("Get databaseMetaData failed: ", (Exception)ex);
            }
            ++n2;
        }
        return false;
    }

    private ShardingTransactionType getAnnotation(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ShardingTransactionType result = method.getAnnotation(ShardingTransactionType.class);
        if (null == result) {
            result = method.getDeclaringClass().getAnnotation(ShardingTransactionType.class);
        }
        return result;
    }

    private static enum TransactionManagerType {
        DATASOURCE("org.springframework.jdbc.datasource.DataSourceTransactionManager"),
        JPA("org.springframework.orm.jpa.JpaTransactionManager"),
        UNSUPPORTED("");

        private final String className;

        private static TransactionManagerType getTransactionManagerTypeByClassName(String className) {
            for (TransactionManagerType each : TransactionManagerType.values()) {
                if (!each.getClassName().equals(className)) continue;
                return each;
            }
            return UNSUPPORTED;
        }

        private TransactionManagerType(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

