/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.handler;

import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.transaction.api.TransactionType;
import io.shardingsphere.transaction.handler.TransactionManagerHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractTransactionManagerHandler
implements TransactionManagerHandler {
    private static final String SET_TRANSACTION_TYPE_SQL = "SCTL:SET TRANSACTION_TYPE=%s";

    @Override
    public final void switchTransactionType(TransactionType transactionType) {
        Connection connection = this.getConnectionFromTransactionManager();
        try (Statement statement = connection.createStatement();){
            statement.execute(String.format(SET_TRANSACTION_TYPE_SQL, transactionType.name()));
        }
        catch (SQLException ex) {
            throw new ShardingException("Switch transaction type for sharding-proxy failed: ", (Exception)ex);
        }
    }

    protected abstract Connection getConnectionFromTransactionManager();
}

