/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.handler;

import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.transaction.handler.AbstractTransactionManagerHandler;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public final class DataSourceTransactionManagerHandler
extends AbstractTransactionManagerHandler {
    private final DataSourceTransactionManager transactionManager;

    public DataSourceTransactionManagerHandler(PlatformTransactionManager transactionManager) {
        this.transactionManager = (DataSourceTransactionManager)transactionManager;
    }

    @Override
    public void unbindResource() {
        ConnectionHolder holder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource((Object)this.transactionManager.getDataSource());
        DataSourceUtils.releaseConnection((Connection)holder.getConnection(), (DataSource)this.transactionManager.getDataSource());
    }

    @Override
    protected Connection getConnectionFromTransactionManager() {
        try {
            Connection result = this.transactionManager.getDataSource().getConnection();
            TransactionSynchronizationManager.bindResource((Object)this.transactionManager.getDataSource(), (Object)new ConnectionHolder(result));
            return result;
        }
        catch (SQLException ex) {
            throw new ShardingException("Could not open JDBC Connection before transaction", (Exception)ex);
        }
    }
}

