/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.handler;

import io.shardingsphere.transaction.handler.AbstractTransactionManagerHandler;
import java.sql.Connection;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;

public final class JpaTransactionManagerHandler
extends AbstractTransactionManagerHandler {
    private final JpaTransactionManager transactionManager;

    public JpaTransactionManagerHandler(PlatformTransactionManager transactionManager) {
        this.transactionManager = (JpaTransactionManager)transactionManager;
    }

    @Override
    public void unbindResource() {
        EntityManagerHolder entityManagerHolder = (EntityManagerHolder)TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.transactionManager.getEntityManagerFactory());
        EntityManagerFactoryUtils.closeEntityManager((EntityManager)entityManagerHolder.getEntityManager());
    }

    @Override
    protected Connection getConnectionFromTransactionManager() {
        EntityManager entityManager = this.createEntityManager();
        Connection result = ((SessionImplementor)entityManager.unwrap(SessionImplementor.class)).connection();
        TransactionSynchronizationManager.bindResource((Object)this.transactionManager.getEntityManagerFactory(), (Object)new EntityManagerHolder(entityManager));
        return result;
    }

    private EntityManager createEntityManager() {
        Map properties;
        EntityManagerFactory entityManagerFactory = this.transactionManager.getEntityManagerFactory();
        if (entityManagerFactory instanceof EntityManagerFactoryInfo) {
            entityManagerFactory = ((EntityManagerFactoryInfo)entityManagerFactory).getNativeEntityManagerFactory();
        }
        return !CollectionUtils.isEmpty((Map)(properties = this.transactionManager.getJpaPropertyMap())) ? entityManagerFactory.createEntityManager(properties) : entityManagerFactory.createEntityManager();
    }
}

