/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.base;

import java.util.Arrays;

public class ObjectUtil {
    private static String NULL = "null";

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static String toPrettyString(Object value) {
        if (value == null) {
            return NULL;
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (componentType.isPrimitive()) {
                StringBuilder sb = new StringBuilder();
                if (componentType == Integer.TYPE) {
                    sb.append(Arrays.toString((int[])value));
                } else if (componentType == Long.TYPE) {
                    sb.append(Arrays.toString((long[])value));
                } else if (componentType == Double.TYPE) {
                    sb.append(Arrays.toString((double[])value));
                } else if (componentType == Float.TYPE) {
                    sb.append(Arrays.toString((float[])value));
                } else if (componentType == Boolean.TYPE) {
                    sb.append(Arrays.toString((boolean[])value));
                } else if (componentType == Short.TYPE) {
                    sb.append(Arrays.toString((short[])value));
                } else if (componentType == Byte.TYPE) {
                    sb.append(Arrays.toString((byte[])value));
                } else {
                    throw new IllegalArgumentException("unsupport array type");
                }
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(ObjectUtil.toPrettyString(array[i]));
            }
            sb.append(']');
            return sb.toString();
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            int i = 0;
            for (Object o : iterable) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(ObjectUtil.toPrettyString(o));
                ++i;
            }
            sb.append('}');
            return sb.toString();
        }
        return value.toString();
    }
}

