/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.utils.base.BooleanUtil;
import org.springside.modules.utils.io.IOUtil;
import org.springside.modules.utils.io.URLResourceUtil;
import org.springside.modules.utils.number.NumberUtil;

public class PropertiesUtil {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesUtil.class);

    public static Boolean getBoolean(Properties p, String name, Boolean defaultValue) {
        return BooleanUtil.toBooleanObject(p.getProperty(name), defaultValue);
    }

    public static Integer getInt(Properties p, String name, Integer defaultValue) {
        return NumberUtil.toIntObject(p.getProperty(name), defaultValue);
    }

    public static Long getLong(Properties p, String name, Long defaultValue) {
        return NumberUtil.toLongObject(p.getProperty(name), defaultValue);
    }

    public static Double getDouble(Properties p, String name, Double defaultValue) {
        return NumberUtil.toDoubleObject(p.getProperty(name), defaultValue);
    }

    public static String getString(Properties p, String name, String defaultValue) {
        return p.getProperty(name, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadFromFile(String generalPath) {
        Properties p = new Properties();
        InputStream is = null;
        try {
            is = URLResourceUtil.asStream(generalPath);
            p.load(is);
        }
        catch (IOException e) {
            logger.warn("Load property from " + generalPath + " fail ", (Throwable)e);
        }
        finally {
            IOUtil.closeQuietly(is);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadFromString(String content) {
        Properties p = new Properties();
        StringReader reader = new StringReader(content);
        try {
            p.load(reader);
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtil.closeQuietly(reader);
        }
        return p;
    }
}

