/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.collection;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.springside.modules.utils.base.annotation.Nullable;

public class ArrayUtil {
    public static <T> T[] shuffle(T[] array) {
        ArrayList list = new ArrayList(array.length);
        Collections.addAll(list, array);
        Collections.shuffle(list);
        return list.toArray(array);
    }

    public static <T> T[] shuffle(T[] array, Random random) {
        ArrayList<T> list = new ArrayList<T>(Arrays.asList(array));
        Collections.shuffle(list, random);
        return list.toArray(array);
    }

    public static <T> T[] concat(@Nullable T element, T[] array) {
        return ObjectArrays.concat(element, (Object[])array);
    }

    public static <T> T[] concat(T[] array, @Nullable T element) {
        return ObjectArrays.concat((Object[])array, element);
    }

    public static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> T[] toArray(List<T> list, Class<T> type) {
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }

    public static <T> List<T> asList(T ... a) {
        return Arrays.asList(a);
    }

    public static <E> List<E> asList(E first, E[] rest) {
        return Lists.asList(first, (Object[])rest);
    }

    public static List<Integer> intAsList(int ... backingArray) {
        return Ints.asList((int[])backingArray);
    }

    public static List<Long> longAsList(long ... backingArray) {
        return Longs.asList((long[])backingArray);
    }

    public static List<Double> doubleAsList(double ... backingArray) {
        return Doubles.asList((double[])backingArray);
    }
}

