/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.concurrent;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDumpper {
    private static final int DEFAULT_MAX_STACK_LEVEL = 8;
    private static Logger logger = LoggerFactory.getLogger(ThreadDumpper.class);
    private boolean enable = true;
    private long leastIntervalMills = 0L;
    private int maxStackLevel = 8;
    private volatile Long lastThreadDumpTime = 0L;

    public ThreadDumpper() {
    }

    public ThreadDumpper(long leastIntervalMills, int maxStackLevel) {
        this.leastIntervalMills = leastIntervalMills;
        this.maxStackLevel = maxStackLevel;
    }

    public void threadDumpIfNeed() {
        this.threadDumpIfNeed(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadDumpIfNeed(String reasonMsg) {
        if (!this.enable) {
            return;
        }
        ThreadDumpper threadDumpper = this;
        synchronized (threadDumpper) {
            if (System.currentTimeMillis() - this.lastThreadDumpTime < this.leastIntervalMills) {
                return;
            }
            this.lastThreadDumpTime = System.currentTimeMillis();
        }
        logger.info("Thread dump by ThreadDumpper" + (reasonMsg != null ? " for " + reasonMsg : ""));
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        logger.info("Finish the threads snapshot");
        StringBuilder sb = new StringBuilder(163840).append("\n");
        for (Map.Entry<Thread, StackTraceElement[]> entry : threads.entrySet()) {
            this.dumpThreadInfo(entry.getKey(), entry.getValue(), sb);
        }
        logger.info(sb.toString());
    }

    private String dumpThreadInfo(Thread thread, StackTraceElement[] stackTrace, StringBuilder sb) {
        int i;
        sb.append("\"").append(thread.getName()).append("\" Id=").append(thread.getId()).append(' ').append((Object)thread.getState());
        sb.append('\n');
        for (i = 0; i < Math.min(this.maxStackLevel, stackTrace.length); ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat ").append(ste.toString()).append('\n');
        }
        if (i < stackTrace.length) {
            sb.append("\t...").append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLeastInterval(int leastIntervalSeconds) {
        ThreadDumpper threadDumpper = this;
        synchronized (threadDumpper) {
            this.leastIntervalMills = TimeUnit.SECONDS.toMillis(leastIntervalSeconds);
        }
    }

    public void setMaxStackLevel(int maxStackLevel) {
        this.maxStackLevel = maxStackLevel;
    }
}

