/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.io;

import com.google.common.io.Files;
import org.apache.commons.lang3.StringUtils;
import org.springside.modules.utils.base.Platforms;
import org.springside.modules.utils.text.MoreStringUtil;

public class FilePathUtil {
    public static String normalizePath(String path) {
        if (Platforms.FILE_PATH_SEPARATOR_CHAR == '\\' && StringUtils.indexOf((CharSequence)path, (int)47) != -1) {
            return StringUtils.replaceChars((String)path, (char)'/', (char)'\\');
        }
        return path;
    }

    public static String simplifyPath(String path) {
        return Files.simplifyPath((String)path);
    }

    public static String contact(String baseName, String ... appendName) {
        if (appendName.length == 0) {
            return baseName;
        }
        String contactName = MoreStringUtil.endWith(baseName, Platforms.FILE_PATH_SEPARATOR_CHAR) ? baseName + appendName[0] : baseName + Platforms.FILE_PATH_SEPARATOR_CHAR + appendName[0];
        if (appendName.length > 1) {
            for (int i = 1; i < appendName.length; ++i) {
                contactName = contactName + Platforms.FILE_PATH_SEPARATOR_CHAR + appendName[i];
            }
        }
        return contactName;
    }

    public static String getParentPath(String path) {
        String parentPath = path;
        if (Platforms.FILE_PATH_SEPARATOR.equals(parentPath)) {
            return parentPath;
        }
        int idx = (parentPath = MoreStringUtil.removeEnd(parentPath, Platforms.FILE_PATH_SEPARATOR_CHAR)).lastIndexOf(Platforms.FILE_PATH_SEPARATOR_CHAR);
        parentPath = idx >= 0 ? parentPath.substring(0, idx + 1) : Platforms.FILE_PATH_SEPARATOR;
        return parentPath;
    }

    public static String getJarPath(Class<?> clazz) {
        return clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
    }
}

