/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.number;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnitConverter {
    private static final Pattern NUMBER_AND_UNIT = Pattern.compile("(\\d+)([a-zA-Z]+)?");

    public static long convertDurationMillis(String duration) {
        Matcher matcher = NUMBER_AND_UNIT.matcher(duration);
        if (matcher.matches()) {
            long number = Long.parseLong(matcher.group(1));
            if (matcher.group(2) != null) {
                String unitStr = matcher.group(2).toLowerCase();
                char unit = unitStr.charAt(0);
                switch (unit) {
                    case 's': {
                        return number * 1000L;
                    }
                    case 'm': {
                        if (unitStr.length() >= 2 && unitStr.charAt(1) == 's') {
                            return number;
                        }
                        return number * 60L * 1000L;
                    }
                    case 'h': {
                        return number * 60L * 60L * 1000L;
                    }
                    case 'd': {
                        return number * 60L * 60L * 24L * 1000L;
                    }
                }
                throw new IllegalArgumentException("unknown time unit :" + unit);
            }
            return number;
        }
        throw new IllegalArgumentException("malformed duration string: " + duration);
    }

    public static long convertSizeBytes(String size) {
        Matcher matcher = NUMBER_AND_UNIT.matcher(size);
        if (matcher.matches()) {
            long number = Long.parseLong(matcher.group(1));
            if (matcher.group(2) != null) {
                char unit = matcher.group(2).toLowerCase().charAt(0);
                switch (unit) {
                    case 'b': {
                        return number;
                    }
                    case 'k': {
                        return number * 1024L;
                    }
                    case 'm': {
                        return number * 1024L * 1024L;
                    }
                    case 'g': {
                        return number * 1024L * 1024L * 1024L;
                    }
                    case 't': {
                        return number * 1024L * 1024L * 1024L * 1024L;
                    }
                }
                throw new IllegalArgumentException("unknown size unit :" + unit);
            }
            return number;
        }
        throw new IllegalArgumentException("malformed size string: " + size);
    }
}

