/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.springside.modules.utils.base.ExceptionUtil;
import org.springside.modules.utils.reflect.ClassUtil;

public class ReflectionUtil {
    public static <T> T invokeGetter(Object obj, String propertyName) {
        Method method = ClassUtil.getGetterMethod(obj.getClass(), propertyName);
        if (method == null) {
            throw new IllegalArgumentException("Could not find getter method [" + propertyName + "] on target [" + obj + ']');
        }
        return ReflectionUtil.invokeMethod(obj, method, new Object[0]);
    }

    public static void invokeSetter(Object obj, String propertyName, Object value) {
        Method method = ClassUtil.getSetterMethod(obj.getClass(), propertyName, value.getClass());
        if (method == null) {
            throw new IllegalArgumentException("Could not find getter method [" + propertyName + "] on target [" + obj + ']');
        }
        ReflectionUtil.invokeMethod(obj, method, value);
    }

    public static <T> T getFieldValue(Object obj, String fieldName) {
        Field field = ClassUtil.getAccessibleField(obj.getClass(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + ']');
        }
        return ReflectionUtil.getFieldValue(obj, field);
    }

    public static <T> T getFieldValue(Object obj, Field field) {
        try {
            return (T)field.get(obj);
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = ClassUtil.getAccessibleField(obj.getClass(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + ']');
        }
        ReflectionUtil.setField(obj, field, value);
    }

    public static void setField(Object obj, Field field, Object value) {
        try {
            field.set(obj, value);
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static <T> T getProperty(Object obj, String propertyName) {
        Method method = ClassUtil.getGetterMethod(obj.getClass(), propertyName);
        if (method != null) {
            try {
                return (T)method.invoke(obj, ArrayUtils.EMPTY_OBJECT_ARRAY);
            }
            catch (Exception e) {
                throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
            }
        }
        return ReflectionUtil.getFieldValue(obj, propertyName);
    }

    public static void setProperty(Object obj, String propertyName, Object value) {
        Method method = ClassUtil.getSetterMethod(obj.getClass(), propertyName, value.getClass());
        if (method != null) {
            try {
                method.invoke(obj, value);
            }
            catch (Exception e) {
                throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
            }
        } else {
            ReflectionUtil.setFieldValue(obj, propertyName, value);
        }
    }

    public static <T> T invokeMethod(Object obj, String methodName, Object ... args) {
        Object[] theArgs = ArrayUtils.nullToEmpty((Object[])args);
        Class[] parameterTypes = ClassUtils.toClass((Object[])theArgs);
        return ReflectionUtil.invokeMethod(obj, methodName, theArgs, parameterTypes);
    }

    public static <T> T invokeMethod(Object obj, String methodName, Object[] args, Class<?>[] parameterTypes) {
        Method method = ClassUtil.getAccessibleMethod(obj.getClass(), methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + obj + ']');
        }
        return ReflectionUtil.invokeMethod(obj, method, args);
    }

    public static <T> T invokeMethodByName(Object obj, String methodName, Object[] args) {
        Method method = ClassUtil.getAccessibleMethodByName(obj.getClass(), methodName);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + obj + ']');
        }
        return ReflectionUtil.invokeMethod(obj, method, args);
    }

    public static <T> T invokeMethod(Object obj, Method method, Object ... args) {
        try {
            return (T)method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ExceptionUtil.uncheckedAndWrap(e);
        }
    }

    public static <T> T invokeConstructor(Class<T> cls, Object ... args) {
        try {
            return (T)ConstructorUtils.invokeConstructor(cls, (Object[])args);
        }
        catch (Exception e) {
            throw ExceptionUtil.uncheckedAndWrap(e);
        }
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new ExceptionUtil.UncheckedException(e);
    }
}

