/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.text;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CsvUtil {
    protected static final char FIELD_SEPARATOR = ',';
    protected static final char FIELD_QUOTE = '\"';
    protected static final String DOUBLE_QUOTE = "\"\"";
    protected static final String SPECIAL_CHARS = "\r\n";
    protected static final String SPACE = " ";
    protected static final String QUOTE = "\"";

    public static String toCsvString(Object ... elements) {
        StringBuilder line = new StringBuilder();
        int last = elements.length - 1;
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null) {
                if (i == last) continue;
                line.append(',');
                continue;
            }
            String field = elements[i].toString();
            int ndx = field.indexOf(44);
            if (ndx == -1) {
                ndx = field.indexOf(34);
            }
            if (ndx == -1 && (field.startsWith(SPACE) || field.endsWith(SPACE))) {
                ndx = 1;
            }
            if (ndx == -1) {
                ndx = StringUtils.indexOf((CharSequence)field, (CharSequence)SPECIAL_CHARS);
            }
            if (ndx != -1) {
                line.append('\"');
            }
            field = StringUtils.replace((String)field, (String)QUOTE, (String)DOUBLE_QUOTE);
            line.append(field);
            if (ndx != -1) {
                line.append('\"');
            }
            if (i == last) continue;
            line.append(',');
        }
        return line.toString();
    }

    public static String[] fromCsvString(String line) {
        ArrayList<String> row = new ArrayList<String>();
        boolean inQuotedField = false;
        int fieldStart = 0;
        int len = line.length();
        for (int i = 0; i < len; ++i) {
            char c = line.charAt(i);
            if (c == ',') {
                if (inQuotedField) continue;
                CsvUtil.addField(row, line, fieldStart, i, inQuotedField);
                fieldStart = i + 1;
                continue;
            }
            if (c != '\"') continue;
            if (inQuotedField) {
                if (i + 1 != len && line.charAt(i + 1) != ',') continue;
                CsvUtil.addField(row, line, fieldStart, i, inQuotedField);
                fieldStart = i + 2;
                ++i;
                inQuotedField = false;
                continue;
            }
            if (fieldStart != i) continue;
            inQuotedField = true;
            ++fieldStart;
        }
        if (len > 0 && fieldStart <= len) {
            CsvUtil.addField(row, line, fieldStart, len, inQuotedField);
        }
        return row.toArray(new String[row.size()]);
    }

    private static void addField(List<String> row, String line, int startIndex, int endIndex, boolean inQuoted) {
        String field = line.substring(startIndex, endIndex);
        if (inQuoted) {
            field = StringUtils.replace((String)field, (String)DOUBLE_QUOTE, (String)QUOTE);
        }
        row.add(field);
    }
}

