/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.time;

import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.springside.modules.utils.base.annotation.NotNull;
import org.springside.modules.utils.time.ClockUtil;
import org.springside.modules.utils.time.DateUtil;

public class DateFormatUtil {
    public static final String PATTERN_ISO = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    public static final String PATTERN_ISO_ON_SECOND = "yyyy-MM-dd'T'HH:mm:ssZZ";
    public static final String PATTERN_ISO_ON_DATE = "yyyy-MM-dd";
    public static final String PATTERN_DEFAULT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String PATTERN_DEFAULT_ON_SECOND = "yyyy-MM-dd HH:mm:ss";
    public static final FastDateFormat ISO_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    public static final FastDateFormat ISO_ON_SECOND_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssZZ");
    public static final FastDateFormat ISO_ON_DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    public static final FastDateFormat DEFAULT_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");
    public static final FastDateFormat DEFAULT_ON_SECOND_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");

    public static Date pareDate(@NotNull String pattern, @NotNull String dateString) throws ParseException {
        return FastDateFormat.getInstance((String)pattern).parse(dateString);
    }

    public static String formatDate(@NotNull String pattern, @NotNull Date date) {
        return FastDateFormat.getInstance((String)pattern).format(date);
    }

    public static String formatDate(@NotNull String pattern, long date) {
        return FastDateFormat.getInstance((String)pattern).format(date);
    }

    public static String formatDuration(@NotNull Date startDate, @NotNull Date endDate) {
        return DurationFormatUtils.formatDurationHMS((long)(endDate.getTime() - startDate.getTime()));
    }

    public static String formatDuration(long durationMillis) {
        return DurationFormatUtils.formatDurationHMS((long)durationMillis);
    }

    public static String formatDurationOnSecond(@NotNull Date startDate, @NotNull Date endDate) {
        return DurationFormatUtils.formatDuration((long)(endDate.getTime() - startDate.getTime()), (String)"HH:mm:ss");
    }

    public static String formatDurationOnSecond(long durationMillis) {
        return DurationFormatUtils.formatDuration((long)durationMillis, (String)"HH:mm:ss");
    }

    public static String formatFriendlyTimeSpanByNow(@NotNull Date date) {
        return DateFormatUtil.formatFriendlyTimeSpanByNow(date.getTime());
    }

    public static String formatFriendlyTimeSpanByNow(long timeStampMillis) {
        long now = ClockUtil.currentTimeMillis();
        long span = now - timeStampMillis;
        if (span < 0L) {
            return String.format("%tc", timeStampMillis);
        }
        if (span < 1000L) {
            return "\u521a\u521a";
        }
        if (span < 60000L) {
            return String.format("%d\u79d2\u524d", span / 1000L);
        }
        if (span < 3600000L) {
            return String.format("%d\u5206\u949f\u524d", span / 60000L);
        }
        long wee = DateUtil.beginOfDate(new Date(now)).getTime();
        if (timeStampMillis >= wee) {
            return String.format("\u4eca\u5929%tR", timeStampMillis);
        }
        if (timeStampMillis >= wee - 86400000L) {
            return String.format("\u6628\u5929%tR", timeStampMillis);
        }
        return String.format("%tF", timeStampMillis);
    }
}

