/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.impl;

import io.vertx.ext.auth.jwt.impl.Crypto;
import java.security.Signature;
import java.security.SignatureException;

final class CryptoSignature
implements Crypto {
    private final Signature sig;

    CryptoSignature(Signature signature) {
        this.sig = signature;
    }

    @Override
    public byte[] sign(byte[] payload) {
        try {
            this.sig.update(payload);
            return this.sig.sign();
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean verify(byte[] signature, byte[] payload) {
        try {
            this.sig.update(payload);
            return this.sig.verify(signature);
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }
}

