/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.AbstractUser;
import io.vertx.ext.auth.AuthProvider;

public final class JWTUser
extends AbstractUser {
    private static final Logger log = LoggerFactory.getLogger(JWTUser.class);
    private final JsonObject jwtToken;
    private final JsonArray permissions;

    public JWTUser(JsonObject jwtToken, String permissionsClaimKey) {
        this.jwtToken = jwtToken;
        this.permissions = jwtToken.getJsonArray(permissionsClaimKey, null);
    }

    public JsonObject principal() {
        return this.jwtToken;
    }

    public void setAuthProvider(AuthProvider authProvider) {
    }

    public void doIsPermitted(String permission, Handler<AsyncResult<Boolean>> handler) {
        if (this.permissions != null) {
            for (Object jwtPermission : this.permissions) {
                if (!permission.equals(jwtPermission)) continue;
                handler.handle((Object)Future.succeededFuture((Object)true));
                return;
            }
        }
        log.debug((Object)("User has no permission [" + permission + "]"));
        handler.handle((Object)Future.succeededFuture((Object)false));
    }
}

