/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.dropwizard.ThroughputMeter;
import java.util.concurrent.TimeUnit;

public class Helper {
    public static JsonObject convertMetric(Metric metric, TimeUnit rateUnit, TimeUnit durationUnit) {
        if (metric instanceof ThroughputMeter) {
            return Helper.toJson((ThroughputMeter)metric, rateUnit);
        }
        if (metric instanceof Timer) {
            return Helper.toJson((Timer)metric, rateUnit, durationUnit);
        }
        if (metric instanceof Gauge) {
            return Helper.toJson((Gauge)metric);
        }
        if (metric instanceof Counter) {
            return Helper.toJson((Counter)metric);
        }
        if (metric instanceof Histogram) {
            return Helper.toJson((Histogram)metric);
        }
        if (metric instanceof Meter) {
            return Helper.toJson((Meter)metric, rateUnit);
        }
        throw new IllegalArgumentException("Unknown metric " + metric);
    }

    private static JsonObject toJson(Gauge gauge) {
        return new JsonObject().put("type", "gauge").put("value", gauge.getValue());
    }

    private static JsonObject toJson(ThroughputMeter throughput, TimeUnit rateUnit) {
        JsonObject json = new JsonObject();
        json.put("type", "meter");
        json.put("oneSecondRate", throughput.getValue());
        Helper.populateMetered(json, (Metered)throughput, rateUnit);
        return json;
    }

    private static JsonObject toJson(Counter counter) {
        return new JsonObject().put("type", "counter").put("count", Long.valueOf(counter.getCount()));
    }

    private static JsonObject toJson(Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        JsonObject json = new JsonObject();
        json.put("type", "histogram");
        json.put("count", Long.valueOf(histogram.getCount()));
        Helper.populateSnapshot(json, snapshot, 1.0);
        return json;
    }

    private static JsonObject toJson(Meter meter, TimeUnit rateUnit) {
        JsonObject json = new JsonObject();
        json.put("type", "meter");
        Helper.populateMetered(json, (Metered)meter, rateUnit);
        return json;
    }

    private static JsonObject toJson(Timer timer, TimeUnit rateUnit, TimeUnit durationUnit) {
        Snapshot snapshot = timer.getSnapshot();
        JsonObject json = new JsonObject();
        json.put("type", "timer");
        Helper.populateMetered(json, (Metered)timer, rateUnit);
        double factor = 1.0 / (double)durationUnit.toNanos(1L);
        Helper.populateSnapshot(json, snapshot, factor);
        String duration = durationUnit.toString().toLowerCase();
        json.put("durationRate", duration);
        return json;
    }

    private static void populateMetered(JsonObject json, Metered meter, TimeUnit rateUnit) {
        double factor = rateUnit.toSeconds(1L);
        json.put("count", Long.valueOf(meter.getCount()));
        json.put("meanRate", Double.valueOf(meter.getMeanRate() * factor));
        json.put("oneMinuteRate", Double.valueOf(meter.getOneMinuteRate() * factor));
        json.put("fiveMinuteRate", Double.valueOf(meter.getFiveMinuteRate() * factor));
        json.put("fifteenMinuteRate", Double.valueOf(meter.getFifteenMinuteRate() * factor));
        String rate = "events/" + rateUnit.toString().toLowerCase();
        json.put("rate", rate);
    }

    private static void populateSnapshot(JsonObject json, Snapshot snapshot, double factor) {
        json.put("min", Double.valueOf((double)snapshot.getMin() * factor));
        json.put("max", Double.valueOf((double)snapshot.getMax() * factor));
        json.put("mean", Double.valueOf(snapshot.getMean() * factor));
        json.put("stddev", Double.valueOf(snapshot.getStdDev() * factor));
        json.put("median", Double.valueOf(snapshot.getMedian() * factor));
        json.put("75%", Double.valueOf(snapshot.get75thPercentile() * factor));
        json.put("95%", Double.valueOf(snapshot.get95thPercentile() * factor));
        json.put("98%", Double.valueOf(snapshot.get98thPercentile() * factor));
        json.put("99%", Double.valueOf(snapshot.get99thPercentile() * factor));
        json.put("99.9%", Double.valueOf(snapshot.get999thPercentile() * factor));
    }
}

