/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Timer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.WebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.ext.dropwizard.Match;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;
import io.vertx.ext.dropwizard.impl.HttpClientReporter;
import io.vertx.ext.dropwizard.impl.Matcher;
import io.vertx.ext.dropwizard.impl.RequestMetric;
import io.vertx.ext.dropwizard.impl.WebSocketMetric;
import java.util.List;

class HttpClientMetricsImpl
extends AbstractMetrics
implements HttpClientMetrics<RequestMetric, WebSocketMetric, Timer.Context> {
    private final HttpClientReporter clientReporter;
    private final Matcher uriMatcher;
    private final int maxPoolSize;

    HttpClientMetricsImpl(HttpClientReporter clientReporter, HttpClientOptions options, List<Match> monitoredUris) {
        super(clientReporter.registry, clientReporter.baseName);
        this.clientReporter = clientReporter;
        this.uriMatcher = new Matcher(monitoredUris);
        this.maxPoolSize = options.getMaxPoolSize();
        clientReporter.incMaxPoolSize(this.maxPoolSize);
    }

    public RequestMetric requestBegin(Timer.Context socketMetric, SocketAddress localAddress, SocketAddress remoteAddress, HttpClientRequest request) {
        return this.clientReporter.createRequestMetric(request.method(), request.uri());
    }

    public void responseEnd(RequestMetric metric, HttpClientResponse response) {
        this.clientReporter.end(metric, response.statusCode(), metric.uri != null && this.uriMatcher.match(metric.uri));
    }

    public WebSocketMetric connected(Timer.Context socketMetric, WebSocket webSocket) {
        return this.clientReporter.createWebSocketMetric();
    }

    public void disconnected(WebSocketMetric webSocketMetric) {
        this.clientReporter.disconnect(webSocketMetric);
    }

    public Timer.Context connected(SocketAddress remoteAddress, String remoteName) {
        return this.clientReporter.connected(remoteAddress, remoteName);
    }

    public void disconnected(Timer.Context socketMetric, SocketAddress remoteAddress) {
        this.clientReporter.disconnected(socketMetric, remoteAddress);
    }

    public void bytesRead(Timer.Context socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.clientReporter.bytesRead(socketMetric, remoteAddress, numberOfBytes);
    }

    public void bytesWritten(Timer.Context socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.clientReporter.bytesWritten(socketMetric, remoteAddress, numberOfBytes);
    }

    public void exceptionOccurred(Timer.Context socketMetric, SocketAddress remoteAddress, Throwable t) {
        this.clientReporter.exceptionOccurred(socketMetric, remoteAddress, t);
    }

    @Override
    public boolean isEnabled() {
        return this.clientReporter.isEnabled();
    }

    public void close() {
        this.clientReporter.decMaxPoolSize(this.maxPoolSize);
    }
}

