/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.ext.mongo.impl.MongoClientImpl;
import java.util.List;
import java.util.UUID;

@VertxGen
public interface MongoClient {
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";
    public static final String DEFAULT_DB_NAME = "DEFAULT_DB";

    public static MongoClient createNonShared(Vertx vertx, JsonObject config) {
        return new MongoClientImpl(vertx, config, UUID.randomUUID().toString());
    }

    public static MongoClient createShared(Vertx vertx, JsonObject config, String dataSourceName) {
        return new MongoClientImpl(vertx, config, dataSourceName);
    }

    public static MongoClient createShared(Vertx vertx, JsonObject config) {
        return new MongoClientImpl(vertx, config, DEFAULT_POOL_NAME);
    }

    @Fluent
    public MongoClient save(String var1, JsonObject var2, Handler<AsyncResult<String>> var3);

    @Fluent
    public MongoClient saveWithOptions(String var1, JsonObject var2, WriteOption var3, Handler<AsyncResult<String>> var4);

    @Fluent
    public MongoClient insert(String var1, JsonObject var2, Handler<AsyncResult<String>> var3);

    @Fluent
    public MongoClient insertWithOptions(String var1, JsonObject var2, WriteOption var3, Handler<AsyncResult<String>> var4);

    @Fluent
    public MongoClient update(String var1, JsonObject var2, JsonObject var3, Handler<AsyncResult<Void>> var4);

    @Fluent
    public MongoClient updateWithOptions(String var1, JsonObject var2, JsonObject var3, UpdateOptions var4, Handler<AsyncResult<Void>> var5);

    @Fluent
    public MongoClient replace(String var1, JsonObject var2, JsonObject var3, Handler<AsyncResult<Void>> var4);

    @Fluent
    public MongoClient replaceWithOptions(String var1, JsonObject var2, JsonObject var3, UpdateOptions var4, Handler<AsyncResult<Void>> var5);

    @Fluent
    public MongoClient find(String var1, JsonObject var2, Handler<AsyncResult<List<JsonObject>>> var3);

    @Fluent
    public MongoClient findWithOptions(String var1, JsonObject var2, FindOptions var3, Handler<AsyncResult<List<JsonObject>>> var4);

    @Fluent
    public MongoClient findOne(String var1, JsonObject var2, JsonObject var3, Handler<AsyncResult<JsonObject>> var4);

    @Fluent
    public MongoClient count(String var1, JsonObject var2, Handler<AsyncResult<Long>> var3);

    @Fluent
    public MongoClient remove(String var1, JsonObject var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public MongoClient removeWithOptions(String var1, JsonObject var2, WriteOption var3, Handler<AsyncResult<Void>> var4);

    @Fluent
    public MongoClient removeOne(String var1, JsonObject var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public MongoClient removeOneWithOptions(String var1, JsonObject var2, WriteOption var3, Handler<AsyncResult<Void>> var4);

    @Fluent
    public MongoClient createCollection(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public MongoClient getCollections(Handler<AsyncResult<List<String>>> var1);

    @Fluent
    public MongoClient dropCollection(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public MongoClient runCommand(String var1, JsonObject var2, Handler<AsyncResult<JsonObject>> var3);

    public void close();
}

