/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.codec.json;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.codec.json.AbstractJsonCodec;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.types.ObjectId;

public class JsonObjectCodec
extends AbstractJsonCodec<JsonObject, JsonArray>
implements CollectibleCodec<JsonObject> {
    public static final String ID_FIELD = "_id";
    public static final String DATE_FIELD = "$date";

    public JsonObject generateIdIfAbsentFromDocument(JsonObject json) {
        if (!this.documentHasId(json)) {
            ObjectId id = new ObjectId();
            json.put(ID_FIELD, id.toHexString());
        }
        return json;
    }

    public boolean documentHasId(JsonObject json) {
        return json.containsKey(ID_FIELD);
    }

    public BsonValue getDocumentId(JsonObject json) {
        if (!this.documentHasId(json)) {
            throw new IllegalStateException("The document does not contain an _id");
        }
        Object id = json.getValue(ID_FIELD);
        if (id instanceof String) {
            return new BsonString((String)id);
        }
        BsonDocument idHoldingDocument = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(idHoldingDocument);
        writer.writeStartDocument();
        writer.writeName(ID_FIELD);
        this.writeValue((BsonWriter)writer, null, id, EncoderContext.builder().build());
        writer.writeEndDocument();
        return idHoldingDocument.get((Object)ID_FIELD);
    }

    public Class<JsonObject> getEncoderClass() {
        return JsonObject.class;
    }

    @Override
    protected void beforeFields(JsonObject object, BiConsumer<String, Object> objectConsumer) {
        if (object.containsKey(ID_FIELD)) {
            objectConsumer.accept(ID_FIELD, object.getValue(ID_FIELD));
        }
    }

    @Override
    protected JsonObject newObject() {
        return new JsonObject();
    }

    @Override
    protected void add(JsonObject object, String name, Object value) {
        object.put(name, value);
    }

    @Override
    protected boolean isObjectInstance(Object instance) {
        return instance instanceof JsonObject;
    }

    @Override
    protected void forEach(JsonObject object, BiConsumer<String, Object> objectConsumer) {
        object.forEach(entry -> objectConsumer.accept((String)entry.getKey(), entry.getValue()));
    }

    @Override
    protected JsonArray newArray() {
        return new JsonArray();
    }

    @Override
    protected void add(JsonArray array, Object value) {
        if (value != null) {
            array.add(value);
        } else {
            array.addNull();
        }
    }

    @Override
    protected boolean isArrayInstance(Object instance) {
        return instance instanceof JsonArray;
    }

    @Override
    protected void forEach(JsonArray array, Consumer<Object> arrayConsumer) {
        array.forEach(arrayConsumer);
    }

    @Override
    protected BsonType getBsonType(Object value) {
        JsonObject obj;
        BsonType type = super.getBsonType(value);
        if (type == BsonType.DOCUMENT && (obj = (JsonObject)value).containsKey(DATE_FIELD)) {
            return BsonType.DATE_TIME;
        }
        return type;
    }

    @Override
    protected Object readObjectId(BsonReader reader, DecoderContext ctx) {
        return reader.readObjectId().toHexString();
    }

    @Override
    protected Object readDateTime(BsonReader reader, DecoderContext ctx) {
        JsonObject result = new JsonObject();
        result.put(DATE_FIELD, OffsetDateTime.ofInstant(Instant.ofEpochMilli(reader.readDateTime()), ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        return result;
    }

    @Override
    protected void writeDateTime(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        writer.writeDateTime(OffsetDateTime.parse(((JsonObject)value).getString(DATE_FIELD)).toInstant().toEpochMilli());
    }
}

