/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ProxyHandler;
import java.lang.reflect.Constructor;

public class ProxyHelper {
    public static final long DEFAULT_CONNECTION_TIMEOUT = 300L;

    public static <T> T createProxy(Class<T> clazz, Vertx vertx, String address) {
        String proxyClassName = clazz.getName() + "VertxEBProxy";
        Class<?> proxyClass = ProxyHelper.loadClass(proxyClassName, clazz);
        Constructor constructor = ProxyHelper.getConstructor(proxyClass, Vertx.class, String.class);
        Object instance = ProxyHelper.createInstance(constructor, vertx, address);
        return (T)instance;
    }

    public static <T> MessageConsumer<JsonObject> registerService(Class<T> clazz, Vertx vertx, T service, String address) {
        return ProxyHelper.registerService(clazz, vertx, service, address, 300L);
    }

    public static <T> MessageConsumer<JsonObject> registerService(Class<T> clazz, Vertx vertx, T service, String address, long timeoutSeconds) {
        return ProxyHelper.registerService(clazz, vertx, service, address, true, timeoutSeconds);
    }

    public static <T> MessageConsumer<JsonObject> registerService(Class<T> clazz, Vertx vertx, T service, String address, boolean topLevel, long timeoutSeconds) {
        String handlerClassName = clazz.getName() + "VertxProxyHandler";
        Class<?> handlerClass = ProxyHelper.loadClass(handlerClassName, clazz);
        Constructor constructor = ProxyHelper.getConstructor(handlerClass, Vertx.class, clazz, Boolean.TYPE, Long.TYPE);
        Object instance = ProxyHelper.createInstance(constructor, vertx, service, topLevel, timeoutSeconds);
        ProxyHandler handler = (ProxyHandler)instance;
        return handler.registerHandler(address);
    }

    private static Class<?> loadClass(String name, Class origin) {
        try {
            return origin.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot find proxyClass: " + name, e);
        }
    }

    private static Constructor getConstructor(Class<?> clazz, Class<?> ... types) {
        try {
            return clazz.getDeclaredConstructor(types);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot find constructor on: " + clazz.getName(), e);
        }
    }

    private static Object createInstance(Constructor constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to call constructor on", e);
        }
    }
}

