/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.impl.FileUploadImpl;
import java.io.File;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class BodyHandlerImpl
implements BodyHandler {
    private static final String BODY_HANDLED = "__body-handled";
    private long bodyLimit = -1L;
    private String uploadsDir;
    private boolean mergeFormAttributes = true;

    public BodyHandlerImpl() {
        this.setUploadsDirectory("file-uploads");
    }

    public BodyHandlerImpl(String uploadDirectory) {
        this.setUploadsDirectory(uploadDirectory);
    }

    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        Boolean handled = (Boolean)context.get(BODY_HANDLED);
        if (handled == null || !handled.booleanValue()) {
            BHandler handler = new BHandler(context);
            request.handler((Handler)handler);
            request.endHandler(v -> handler.end());
            context.put(BODY_HANDLED, true);
        } else {
            context.next();
        }
    }

    @Override
    public BodyHandler setBodyLimit(long bodyLimit) {
        this.bodyLimit = bodyLimit;
        return this;
    }

    @Override
    public BodyHandler setUploadsDirectory(String uploadsDirectory) {
        this.uploadsDir = uploadsDirectory;
        return this;
    }

    @Override
    public BodyHandler setMergeFormAttributes(boolean mergeFormAttributes) {
        this.mergeFormAttributes = mergeFormAttributes;
        return this;
    }

    private class BHandler
    implements Handler<Buffer> {
        RoutingContext context;
        Buffer body = Buffer.buffer();
        boolean failed;
        AtomicInteger uploadCount = new AtomicInteger();
        boolean ended;

        public BHandler(RoutingContext context) {
            this.context = context;
            Set<FileUpload> fileUploads = context.fileUploads();
            this.makeUploadDir(context.vertx().fileSystem());
            context.request().setExpectMultipart(true);
            context.request().exceptionHandler(context::fail);
            context.request().uploadHandler(upload -> {
                this.uploadCount.incrementAndGet();
                String uploadedFileName = new File(BodyHandlerImpl.this.uploadsDir, UUID.randomUUID().toString()).getPath();
                upload.streamToFileSystem(uploadedFileName);
                FileUploadImpl fileUpload = new FileUploadImpl(uploadedFileName, (HttpServerFileUpload)upload);
                fileUploads.add(fileUpload);
                upload.exceptionHandler(context::fail);
                upload.endHandler(v -> this.uploadEnded());
            });
        }

        private void makeUploadDir(FileSystem fileSystem) {
            if (!fileSystem.existsBlocking(BodyHandlerImpl.this.uploadsDir)) {
                fileSystem.mkdirsBlocking(BodyHandlerImpl.this.uploadsDir);
            }
        }

        public void handle(Buffer buff) {
            if (this.failed) {
                return;
            }
            if (BodyHandlerImpl.this.bodyLimit != -1L && (long)(this.body.length() + buff.length()) > BodyHandlerImpl.this.bodyLimit) {
                this.failed = true;
                this.context.fail(413);
            } else {
                this.body.appendBuffer(buff);
            }
        }

        void uploadEnded() {
            int count = this.uploadCount.decrementAndGet();
            if (count == 0) {
                this.doEnd();
            }
        }

        void end() {
            if (this.uploadCount.get() == 0) {
                this.doEnd();
            }
        }

        void doEnd() {
            if (this.failed || this.ended) {
                return;
            }
            this.ended = true;
            HttpServerRequest req = this.context.request();
            if (BodyHandlerImpl.this.mergeFormAttributes && req.isExpectMultipart()) {
                req.params().addAll(req.formAttributes());
            }
            this.context.setBody(this.body);
            this.context.next();
        }
    }
}

