/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server;

import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import zipkin.Component;

final class ZipkinHealthIndicator
extends CompositeHealthIndicator {
    ZipkinHealthIndicator(HealthAggregator healthAggregator) {
        super(healthAggregator);
    }

    void addComponent(Component component) {
        String healthName = component.getClass().getSimpleName();
        this.addHealthIndicator(healthName, new ComponentHealthIndicator(component));
    }

    static final class ComponentHealthIndicator
    implements HealthIndicator {
        final Component component;

        ComponentHealthIndicator(Component component) {
            this.component = component;
        }

        public Health health() {
            Component.CheckResult result = this.component.check();
            return result.ok ? Health.up().build() : Health.down((Exception)result.exception).build();
        }
    }
}

