/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.storage.elasticsearch.IndexNameFormatter;
import zipkin.storage.elasticsearch.InternalElasticsearchClient;
import zipkin.storage.guava.GuavaSpanConsumer;

final class ElasticsearchSpanConsumer
implements GuavaSpanConsumer {
    private static final byte[] TIMESTAMP_MILLIS_PREFIX = "{\"timestamp_millis\":".getBytes();
    private static final ListenableFuture<Void> VOID = Futures.immediateFuture(null);
    private final InternalElasticsearchClient client;
    private final IndexNameFormatter indexNameFormatter;

    ElasticsearchSpanConsumer(InternalElasticsearchClient client, IndexNameFormatter indexNameFormatter) {
        this.client = client;
        this.indexNameFormatter = indexNameFormatter;
    }

    public ListenableFuture<Void> accept(List<Span> spans) {
        if (spans.isEmpty()) {
            return VOID;
        }
        try {
            return this.indexSpans(this.client.bulkSpanIndexer(), spans).execute();
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    InternalElasticsearchClient.BulkSpanIndexer indexSpans(InternalElasticsearchClient.BulkSpanIndexer indexer, List<Span> spans) throws IOException {
        for (Span span : spans) {
            String index;
            Long timestampMillis;
            Long timestamp = ApplyTimestampAndDuration.guessTimestamp((Span)span);
            if (timestamp != null) {
                timestampMillis = TimeUnit.MICROSECONDS.toMillis(timestamp);
                index = this.indexNameFormatter.indexNameForTimestamp(timestampMillis);
            } else {
                timestampMillis = null;
                index = this.indexNameFormatter.indexNameForTimestamp(System.currentTimeMillis());
            }
            indexer.add(index, span, timestampMillis);
        }
        return indexer;
    }

    @VisibleForTesting
    static byte[] prefixWithTimestampMillis(byte[] input, long timestampMillis) {
        String dateAsString = Long.toString(timestampMillis);
        byte[] newSpanBytes = new byte[TIMESTAMP_MILLIS_PREFIX.length + dateAsString.length() + input.length];
        int pos = 0;
        System.arraycopy(TIMESTAMP_MILLIS_PREFIX, 0, newSpanBytes, pos, TIMESTAMP_MILLIS_PREFIX.length);
        pos += TIMESTAMP_MILLIS_PREFIX.length;
        int length = dateAsString.length();
        for (int i = 0; i < length; ++i) {
            newSpanBytes[pos++] = (byte)dateAsString.charAt(i);
        }
        newSpanBytes[pos++] = 44;
        System.arraycopy(input, 1, newSpanBytes, pos, input.length - 1);
        return newSpanBytes;
    }
}

