/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.CorrectForClockSkew;
import zipkin.internal.DependencyLinker;
import zipkin.internal.MergeById;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.storage.QueryRequest;
import zipkin.storage.elasticsearch.IndexNameFormatter;
import zipkin.storage.elasticsearch.InternalElasticsearchClient;
import zipkin.storage.guava.GuavaSpanStore;

final class ElasticsearchSpanStore
implements GuavaSpanStore {
    static final ListenableFuture<List<String>> EMPTY_LIST = Futures.immediateFuture(Collections.emptyList());
    static final Ordering<List<Span>> TRACE_DESCENDING = Ordering.from((Comparator)new Comparator<List<Span>>(){

        @Override
        public int compare(List<Span> left, List<Span> right) {
            return right.get(0).compareTo(left.get(0));
        }
    });
    private final InternalElasticsearchClient client;
    private final IndexNameFormatter indexNameFormatter;
    private final String[] catchAll;

    ElasticsearchSpanStore(InternalElasticsearchClient client, IndexNameFormatter indexNameFormatter) {
        this.client = client;
        this.indexNameFormatter = indexNameFormatter;
        this.catchAll = new String[]{indexNameFormatter.catchAll()};
    }

    public ListenableFuture<List<List<Span>>> getTraces(QueryRequest request) {
        long endMillis = request.endTs;
        long beginMillis = endMillis - request.lookback;
        BoolQueryBuilder filter = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp_millis").gte(beginMillis).lte(endMillis));
        if (request.serviceName != null) {
            filter.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.nestedQuery((String)"annotations", (QueryBuilder)QueryBuilders.termQuery((String)"annotations.endpoint.serviceName", (String)request.serviceName))).should((QueryBuilder)QueryBuilders.nestedQuery((String)"binaryAnnotations", (QueryBuilder)QueryBuilders.termQuery((String)"binaryAnnotations.endpoint.serviceName", (String)request.serviceName))));
        }
        if (request.spanName != null) {
            filter.must((QueryBuilder)QueryBuilders.termQuery((String)"name", (String)request.spanName));
        }
        for (String string : request.annotations) {
            BoolQueryBuilder annotationQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"annotations.value", (String)string));
            if (request.serviceName != null) {
                annotationQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"annotations.endpoint.serviceName", (String)request.serviceName));
            }
            filter.must((QueryBuilder)QueryBuilders.nestedQuery((String)"annotations", (QueryBuilder)annotationQuery));
        }
        for (Map.Entry entry : request.binaryAnnotations.entrySet()) {
            BoolQueryBuilder binaryAnnotationQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"binaryAnnotations.key", (String)((String)entry.getKey()))).must((QueryBuilder)QueryBuilders.termQuery((String)"binaryAnnotations.value", (String)((String)entry.getValue())));
            if (request.serviceName != null) {
                binaryAnnotationQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"binaryAnnotations.endpoint.serviceName", (String)request.serviceName));
            }
            filter.must((QueryBuilder)QueryBuilders.nestedQuery((String)"binaryAnnotations", (QueryBuilder)binaryAnnotationQuery));
        }
        if (request.minDuration != null) {
            RangeQueryBuilder durationQuery = QueryBuilders.rangeQuery((String)"duration").gte((Object)request.minDuration);
            if (request.maxDuration != null) {
                durationQuery.lte((Object)request.maxDuration);
            }
            filter.must((QueryBuilder)durationQuery);
        }
        Set<String> strings = this.indexNameFormatter.indexNamePatternsForRange(beginMillis, endMillis);
        final String[] stringArray = strings.toArray(new String[0]);
        ListenableFuture<List<String>> traceIds = this.client.collectBucketKeys(stringArray, (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).filter((QueryBuilder)filter), new AbstractAggregationBuilder[]{((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"traceId_agg").field("traceId")).subAggregation((AbstractAggregationBuilder)AggregationBuilders.min((String)"timestamps_agg").field("timestamp_millis"))).order(Terms.Order.aggregation((String)"timestamps_agg", (boolean)false)).size(request.limit)});
        return Futures.transform(traceIds, (AsyncFunction)new AsyncFunction<List<String>, List<List<Span>>>(){

            public ListenableFuture<List<List<Span>>> apply(List<String> input) {
                ArrayList<Long> traceIds = new ArrayList<Long>(input.size());
                for (String bucket : input) {
                    traceIds.add(Util.lowerHexToUnsignedLong((String)bucket));
                }
                return ElasticsearchSpanStore.this.getTracesByIds(traceIds, stringArray);
            }
        });
    }

    public ListenableFuture<List<Span>> getTrace(long traceId) {
        return Futures.transform(this.getRawTrace(traceId), (Function)new Function<List<Span>, List<Span>>(){

            public List<Span> apply(List<Span> input) {
                return input == null ? null : CorrectForClockSkew.apply((List)MergeById.apply(input));
            }
        });
    }

    public ListenableFuture<List<Span>> getRawTrace(long traceId) {
        return this.client.findSpans(this.catchAll, (QueryBuilder)QueryBuilders.termQuery((String)"traceId", (String)Util.toLowerHex((long)traceId)));
    }

    ListenableFuture<List<List<Span>>> getTracesByIds(Collection<Long> traceIds, String[] indices) {
        ArrayList<String> traceIdsStr = new ArrayList<String>(traceIds.size());
        for (long traceId : traceIds) {
            traceIdsStr.add(Util.toLowerHex((long)traceId));
        }
        return Futures.transform(this.client.findSpans(indices, (QueryBuilder)QueryBuilders.termsQuery((String)"traceId", traceIdsStr)), (Function)ConvertTracesResponse.INSTANCE);
    }

    public ListenableFuture<List<String>> getServiceNames() {
        return this.client.collectBucketKeys(this.catchAll, (QueryBuilder)QueryBuilders.matchAllQuery(), new AbstractAggregationBuilder[]{AggregationBuilders.nested((String)"annotations_agg").path("annotations").subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)"annotationsServiceName_agg").field("annotations.endpoint.serviceName")).size(0)), AggregationBuilders.nested((String)"binaryAnnotations_agg").path("binaryAnnotations").subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)"binaryAnnotationsServiceName_agg").field("binaryAnnotations.endpoint.serviceName")).size(0))});
    }

    public ListenableFuture<List<String>> getSpanNames(String serviceName) {
        if (Strings.isNullOrEmpty((String)serviceName)) {
            return EMPTY_LIST;
        }
        serviceName = serviceName.toLowerCase();
        BoolQueryBuilder filter = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.nestedQuery((String)"annotations", (QueryBuilder)QueryBuilders.termQuery((String)"annotations.endpoint.serviceName", (String)serviceName))).should((QueryBuilder)QueryBuilders.nestedQuery((String)"binaryAnnotations", (QueryBuilder)QueryBuilders.termQuery((String)"binaryAnnotations.endpoint.serviceName", (String)serviceName)));
        return this.client.collectBucketKeys(this.catchAll, (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).filter((QueryBuilder)filter), new AbstractAggregationBuilder[]{((TermsBuilder)AggregationBuilders.terms((String)"name_agg").order(Terms.Order.term((boolean)true)).field("name")).size(0)});
    }

    public ListenableFuture<List<DependencyLink>> getDependencies(long endMillis, @Nullable Long lookback) {
        long beginMillis = lookback != null ? endMillis - lookback : 0L;
        Set<String> indices = this.indexNameFormatter.indexNamePatternsForRange(beginMillis, endMillis);
        return Futures.transform(this.client.findDependencies(indices.toArray(new String[0])), (Function)new Function<List<DependencyLink>, List<DependencyLink>>(){

            public List<DependencyLink> apply(List<DependencyLink> input) {
                return input == null ? Collections.emptyList() : DependencyLinker.merge(input);
            }
        });
    }

    static enum ConvertTracesResponse implements Function<List<Span>, List<List<Span>>>
    {
        INSTANCE;


        public List<List<Span>> apply(List<Span> response) {
            if (response == null) {
                return ImmutableList.of();
            }
            ArrayListMultimap groupedSpans = ArrayListMultimap.create();
            for (Span span : response) {
                groupedSpans.put((Object)span.traceId, (Object)span);
            }
            ArrayList<List> result = new ArrayList<List>(groupedSpans.size());
            for (Long traceId : groupedSpans.keySet()) {
                result.add(CorrectForClockSkew.apply((List)MergeById.apply((Collection)groupedSpans.get((Object)traceId))));
            }
            return TRACE_DESCENDING.immutableSortedCopy(result);
        }
    }
}

