/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.List;
import zipkin.Component;
import zipkin.internal.Util;
import zipkin.storage.elasticsearch.ElasticsearchSpanConsumer;
import zipkin.storage.elasticsearch.ElasticsearchSpanStore;
import zipkin.storage.elasticsearch.IndexNameFormatter;
import zipkin.storage.elasticsearch.InternalElasticsearchClient;
import zipkin.storage.elasticsearch.LazyClient;
import zipkin.storage.elasticsearch.NativeClient;
import zipkin.storage.guava.LazyGuavaStorageComponent;

public final class ElasticsearchStorage
extends LazyGuavaStorageComponent<ElasticsearchSpanStore, ElasticsearchSpanConsumer> {
    private final LazyClient lazyClient;
    @VisibleForTesting
    final IndexNameFormatter indexNameFormatter;

    public static Builder builder() {
        return new Builder(new NativeClient.Builder());
    }

    public static Builder builder(InternalElasticsearchClient.Builder clientBuilder) {
        return new Builder((InternalElasticsearchClient.Builder)Util.checkNotNull((Object)clientBuilder, (String)"clientBuilder"));
    }

    ElasticsearchStorage(Builder builder) {
        this.lazyClient = new LazyClient(builder);
        this.indexNameFormatter = new IndexNameFormatter(builder.index);
    }

    @VisibleForTesting
    InternalElasticsearchClient client() {
        return (InternalElasticsearchClient)this.lazyClient.get();
    }

    protected ElasticsearchSpanStore computeGuavaSpanStore() {
        return new ElasticsearchSpanStore(this.client(), this.indexNameFormatter);
    }

    protected ElasticsearchSpanConsumer computeGuavaSpanConsumer() {
        return new ElasticsearchSpanConsumer(this.client(), this.indexNameFormatter);
    }

    @VisibleForTesting
    void clear() throws IOException {
        ((InternalElasticsearchClient)this.lazyClient.get()).clear(this.indexNameFormatter.catchAll());
    }

    public Component.CheckResult check() {
        try {
            this.client().ensureClusterReady(this.indexNameFormatter.catchAll());
        }
        catch (UncheckedExecutionException e) {
            return Component.CheckResult.failed((Exception)((Exception)e.getCause()));
        }
        catch (Exception e) {
            return Component.CheckResult.failed((Exception)e);
        }
        return Component.CheckResult.OK;
    }

    public void close() throws IOException {
        this.lazyClient.close();
    }

    public String toString() {
        return this.lazyClient.toString();
    }

    public static final class Builder {
        final InternalElasticsearchClient.Builder clientBuilder;
        String index = "zipkin";
        int indexShards = 5;
        int indexReplicas = 1;

        Builder(InternalElasticsearchClient.Builder clientBuilder) {
            this.clientBuilder = clientBuilder;
        }

        public Builder cluster(String cluster) {
            this.clientBuilder.cluster(cluster);
            return this;
        }

        public Builder hosts(List<String> hosts) {
            this.clientBuilder.hosts(hosts);
            return this;
        }

        public Builder index(String index) {
            this.index = (String)Util.checkNotNull((Object)index, (String)"index");
            return this;
        }

        public Builder indexShards(int indexShards) {
            this.indexShards = indexShards;
            return this;
        }

        public Builder indexReplicas(int indexReplicas) {
            this.indexReplicas = indexReplicas;
            return this;
        }

        @VisibleForTesting
        Builder flushOnWrites(boolean flushOnWrites) {
            this.clientBuilder.flushOnWrites(flushOnWrites);
            return this;
        }

        public ElasticsearchStorage build() {
            return new ElasticsearchStorage(this);
        }
    }
}

