/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TimeZone;
import zipkin.internal.Util;

final class IndexNameFormatter {
    private static final String DAILY_INDEX_FORMAT = "yyyy-MM-dd";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final String index;
    private final ThreadLocal<SimpleDateFormat> dateFormat;

    IndexNameFormatter(String index) {
        this.index = index;
        this.dateFormat = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat result = new SimpleDateFormat(IndexNameFormatter.DAILY_INDEX_FORMAT);
                result.setTimeZone(TimeZone.getTimeZone("UTC"));
                return result;
            }
        };
    }

    Set<String> indexNamePatternsForRange(long beginMillis, long endMillis) {
        GregorianCalendar end;
        GregorianCalendar current = IndexNameFormatter.midnightUTC(beginMillis);
        if (current.equals(end = IndexNameFormatter.midnightUTC(endMillis))) {
            return Collections.singleton(this.indexNameForTimestamp(current.getTimeInMillis()));
        }
        LinkedHashSet<String> indices = new LinkedHashSet<String>();
        while (current.compareTo(end) <= 0) {
            if (current.get(2) == 0 && current.get(5) == 1) {
                current.set(6, current.getActualMaximum(6));
                if (current.compareTo(end) <= 0) {
                    indices.add(String.format("%s-%s-*", this.index, current.get(1)));
                    current.add(5, 1);
                    continue;
                }
                current.set(6, 1);
            } else if (current.get(5) == 1) {
                current.set(5, current.getActualMaximum(5));
                if (current.compareTo(end) <= 0) {
                    indices.add(String.format("%s-%s-%02d-*", this.index, current.get(1), current.get(2) + 1));
                    current.add(5, 1);
                    continue;
                }
                current.set(5, 1);
            }
            indices.add(this.indexNameForTimestamp(current.getTimeInMillis()));
            current.add(5, 1);
        }
        return indices;
    }

    static GregorianCalendar midnightUTC(long epochMillis) {
        GregorianCalendar result = new GregorianCalendar(UTC);
        result.setTimeInMillis(Util.midnightUTC((long)epochMillis));
        return result;
    }

    String indexNameForTimestamp(long timestampMillis) {
        return this.index + "-" + this.dateFormat.get().format(new Date(timestampMillis));
    }

    String catchAll() {
        return this.index + "-*";
    }
}

