/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import zipkin.Codec;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.Lazy;
import zipkin.storage.elasticsearch.ElasticsearchSpanConsumer;

public abstract class InternalElasticsearchClient
implements Closeable {
    protected static final int MAX_RAW_SPANS = 10000;
    protected static final String SPAN = "span";
    protected static final String DEPENDENCY_LINK = "dependencylink";

    protected abstract void ensureTemplate(String var1, String var2) throws IOException;

    protected abstract void clear(String var1) throws IOException;

    protected abstract ListenableFuture<List<String>> collectBucketKeys(String[] var1, QueryBuilder var2, AbstractAggregationBuilder ... var3);

    protected abstract ListenableFuture<List<Span>> findSpans(String[] var1, QueryBuilder var2);

    protected abstract ListenableFuture<List<DependencyLink>> findDependencies(String[] var1);

    protected abstract BulkSpanIndexer bulkSpanIndexer();

    public static byte[] toSpanBytes(Span span, Long timestampMillis) {
        return timestampMillis != null ? ElasticsearchSpanConsumer.prefixWithTimestampMillis(Codec.JSON.writeSpan(span), timestampMillis) : Codec.JSON.writeSpan(span);
    }

    protected abstract void ensureClusterReady(String var1) throws IOException;

    @Override
    public abstract void close();

    protected static abstract class SpanBytesBulkSpanIndexer
    implements BulkSpanIndexer {
        protected SpanBytesBulkSpanIndexer() {
        }

        @Override
        public final void add(String index, Span span, Long timestampMillis) {
            this.add(index, InternalElasticsearchClient.toSpanBytes(span, timestampMillis));
        }

        protected abstract void add(String var1, byte[] var2);
    }

    public static interface BulkSpanIndexer {
        public void add(String var1, Span var2, Long var3) throws IOException;

        public ListenableFuture<Void> execute() throws IOException;
    }

    public static abstract class Builder {
        public abstract Builder cluster(String var1);

        public abstract Builder hosts(Lazy<List<String>> var1);

        public abstract Builder flushOnWrites(boolean var1);

        public final Builder hosts(final List<String> hosts) {
            Preconditions.checkNotNull(hosts, (Object)"hosts");
            return this.hosts(new Lazy<List<String>>(){

                protected List<String> compute() {
                    return hosts;
                }
            });
        }

        public abstract Factory buildFactory();
    }

    public static interface Factory {
        public InternalElasticsearchClient create(String var1);
    }
}

