/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch;

import com.google.common.io.Resources;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import zipkin.internal.LazyCloseable;
import zipkin.storage.elasticsearch.ElasticsearchStorage;
import zipkin.storage.elasticsearch.IndexNameFormatter;
import zipkin.storage.elasticsearch.InternalElasticsearchClient;

final class LazyClient
extends LazyCloseable<InternalElasticsearchClient> {
    private final InternalElasticsearchClient.Factory clientFactory;
    private final String indexTemplateName;
    final String indexTemplate;
    private final String allIndices;

    LazyClient(ElasticsearchStorage.Builder builder) {
        this.clientFactory = builder.clientBuilder.buildFactory();
        this.indexTemplateName = builder.index + "_template";
        this.allIndices = new IndexNameFormatter(builder.index).catchAll();
        try {
            this.indexTemplate = Resources.toString((URL)Resources.getResource((String)"zipkin/storage/elasticsearch/zipkin_template.json"), (Charset)StandardCharsets.UTF_8).replace("${__INDEX__}", builder.index).replace("${__NUMBER_OF_SHARDS__}", String.valueOf(builder.indexShards)).replace("${__NUMBER_OF_REPLICAS__}", String.valueOf(builder.indexReplicas));
        }
        catch (IOException e) {
            throw new AssertionError("Error reading jar resource, shouldn't happen.", e);
        }
    }

    protected InternalElasticsearchClient compute() {
        InternalElasticsearchClient client = this.clientFactory.create(this.allIndices);
        try {
            client.ensureTemplate(this.indexTemplateName, this.indexTemplate);
        }
        catch (IOException e) {
            client.close();
            throw new UncheckedExecutionException((Throwable)e);
        }
        return client;
    }

    public String toString() {
        return this.clientFactory.toString();
    }
}

