/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import zipkin.Codec;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.Lazy;
import zipkin.internal.Util;
import zipkin.storage.elasticsearch.InternalElasticsearchClient;

final class NativeClient
extends InternalElasticsearchClient {
    final TransportClient client;
    final boolean flushOnWrites;
    private static final Function<Object, Void> TO_VOID = Functions.constant(null);

    NativeClient(TransportClient client, boolean flushOnWrites) {
        this.client = client;
        this.flushOnWrites = flushOnWrites;
    }

    @Override
    public void ensureTemplate(String name, String indexTemplate) {
        GetIndexTemplatesResponse existingTemplates = (GetIndexTemplatesResponse)this.client.admin().indices().getTemplates(new GetIndexTemplatesRequest(new String[]{name})).actionGet();
        if (!existingTemplates.getIndexTemplates().isEmpty()) {
            return;
        }
        this.client.admin().indices().putTemplate(new PutIndexTemplateRequest(name).source(indexTemplate)).actionGet();
    }

    @Override
    public void clear(String index) {
        this.client.admin().indices().delete(new DeleteIndexRequest(index)).actionGet();
        this.client.admin().indices().flush(new FlushRequest(new String[]{index})).actionGet();
    }

    @Override
    public ListenableFuture<List<String>> collectBucketKeys(String[] indices, QueryBuilder query, AbstractAggregationBuilder ... aggregations) {
        SearchRequestBuilder elasticRequest = this.client.prepareSearch(indices).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setTypes(new String[]{"span"}).setQuery(query).setSize(0);
        for (AbstractAggregationBuilder aggregation : aggregations) {
            elasticRequest.addAggregation(aggregation);
        }
        return Futures.transform(NativeClient.toGuava(elasticRequest.execute()), (Function)BucketKeys.INSTANCE);
    }

    @Override
    public ListenableFuture<List<Span>> findSpans(String[] indices, QueryBuilder query) {
        SearchRequestBuilder elasticRequest = this.client.prepareSearch(indices).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setTypes(new String[]{"span"}).setSize(10000).setQuery(query);
        return Futures.transform(NativeClient.toGuava(elasticRequest.execute()), (Function)new Function<SearchResponse, List<Span>>(){

            public List<Span> apply(SearchResponse response) {
                if (response.getHits().totalHits() == 0L) {
                    return null;
                }
                ImmutableList.Builder trace = ImmutableList.builder();
                for (SearchHit hit : response.getHits()) {
                    trace.add((Object)Codec.JSON.readSpan(hit.getSourceRef().toBytes()));
                }
                return trace.build();
            }
        });
    }

    @Override
    public ListenableFuture<List<DependencyLink>> findDependencies(String[] indices) {
        SearchRequestBuilder elasticRequest = this.client.prepareSearch(indices).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setTypes(new String[]{"dependencylink"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        return Futures.transform(NativeClient.toGuava(elasticRequest.execute()), (Function)ConvertDependenciesResponse.INSTANCE);
    }

    @Override
    protected InternalElasticsearchClient.BulkSpanIndexer bulkSpanIndexer() {
        return new InternalElasticsearchClient.SpanBytesBulkSpanIndexer(){
            final List<IndexRequestBuilder> indexRequests = new LinkedList<IndexRequestBuilder>();
            final Set<String> indices = new LinkedHashSet<String>();

            @Override
            protected void add(String index, byte[] spanBytes) {
                this.indexRequests.add(NativeClient.this.client.prepareIndex(index, "span").setSource(spanBytes));
                if (NativeClient.this.flushOnWrites) {
                    this.indices.add(index);
                }
            }

            @Override
            public ListenableFuture<Void> execute() {
                ListenableFuture future;
                if (this.indexRequests.size() == 1) {
                    future = NativeClient.toGuava(this.indexRequests.get(0).execute());
                } else {
                    BulkRequestBuilder request = NativeClient.this.client.prepareBulk();
                    for (IndexRequestBuilder span : this.indexRequests) {
                        request.add(span);
                    }
                    future = NativeClient.toGuava(request.execute());
                }
                if (!this.indices.isEmpty()) {
                    future = Futures.transform(future, (AsyncFunction)new AsyncFunction(){

                        public ListenableFuture apply(Object input) {
                            return NativeClient.toGuava(NativeClient.this.client.admin().indices().prepareFlush(indices.toArray(new String[indices.size()])).execute());
                        }
                    });
                }
                return Futures.transform(future, (Function)TO_VOID);
            }
        };
    }

    @Override
    protected void ensureClusterReady(String catchAll) {
        ClusterHealthResponse health = (ClusterHealthResponse)Futures.getUnchecked((Future)this.client.admin().cluster().prepareHealth(new String[]{catchAll}).execute());
        Preconditions.checkState((health.getStatus() != ClusterHealthStatus.RED ? 1 : 0) != 0, (Object)"Health status is RED");
    }

    @Override
    public void close() {
        this.client.close();
    }

    static <T> ListenableFuture<T> toGuava(ListenableActionFuture<T> elasticFuture) {
        final SettableFuture future = SettableFuture.create();
        elasticFuture.addListener(new ActionListener<T>(){

            public void onResponse(T t) {
                future.set(t);
            }

            public void onFailure(Throwable e) {
                future.setException(e);
            }
        });
        return future;
    }

    static enum ConvertDependenciesResponse implements Function<SearchResponse, List<DependencyLink>>
    {
        INSTANCE;


        public List<DependencyLink> apply(SearchResponse response) {
            if (response.getHits() == null) {
                return ImmutableList.of();
            }
            ImmutableList.Builder unmerged = ImmutableList.builder();
            for (SearchHit hit : response.getHits()) {
                DependencyLink link = Codec.JSON.readDependencyLink(hit.getSourceRef().toBytes());
                unmerged.add((Object)link);
            }
            return unmerged.build();
        }
    }

    static enum BucketKeys implements Function<SearchResponse, List<String>>
    {
        INSTANCE;


        public List<String> apply(SearchResponse input) {
            Iterator aggregations;
            Iterator iterator = aggregations = input.getAggregations() != null ? input.getAggregations().iterator() : null;
            if (aggregations == null) {
                return ImmutableList.of();
            }
            ImmutableSet.Builder result = ImmutableSet.builder();
            while (aggregations.hasNext()) {
                BucketKeys.addBucketKeys((Aggregation)aggregations.next(), (ImmutableSet.Builder<String>)result);
            }
            return Util.sortedList((Collection)result.build());
        }

        static void addBucketKeys(Aggregation input, ImmutableSet.Builder<String> result) {
            block3: {
                block2: {
                    if (!(input instanceof MultiBucketsAggregation)) break block2;
                    MultiBucketsAggregation aggregation = (MultiBucketsAggregation)input;
                    for (MultiBucketsAggregation.Bucket bucket : aggregation.getBuckets()) {
                        result.add((Object)bucket.getKeyAsString());
                    }
                    break block3;
                }
                if (!(input instanceof SingleBucketAggregation)) break block3;
                SingleBucketAggregation aggregation = (SingleBucketAggregation)input;
                for (Aggregation next : aggregation.getAggregations()) {
                    BucketKeys.addBucketKeys(next, result);
                }
            }
        }
    }

    private static final class Factory
    implements InternalElasticsearchClient.Factory {
        final String cluster;
        final Lazy<List<String>> hosts;
        final boolean flushOnWrites;

        Factory(Builder builder) {
            this.cluster = builder.cluster;
            this.hosts = builder.hosts;
            this.flushOnWrites = builder.flushOnWrites;
        }

        @Override
        public InternalElasticsearchClient create(String allIndices) {
            Settings settings = Settings.builder().put("cluster.name", this.cluster).put("lazyClient.transport.sniff", true).build();
            TransportClient client = TransportClient.builder().settings(settings).build();
            for (String host : (List)this.hosts.get()) {
                HostAndPort hostAndPort = HostAndPort.fromString((String)host).withDefaultPort(9300);
                try {
                    client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(hostAndPort.getHostText()), hostAndPort.getPort()));
                }
                catch (UnknownHostException e) {}
            }
            return new NativeClient(client, this.flushOnWrites);
        }

        public String toString() {
            StringBuilder json = new StringBuilder("{\"clusterName\": \"").append(this.cluster).append("\"");
            json.append(", \"hosts\": [\"").append(Joiner.on((String)"\", \"").join((Iterable)this.hosts.get())).append("\"]");
            return json.append("}").toString();
        }
    }

    static final class Builder
    extends InternalElasticsearchClient.Builder {
        String cluster = "elasticsearch";
        Lazy<List<String>> hosts;
        boolean flushOnWrites;

        Builder() {
            this.hosts(Collections.singletonList("localhost:9300"));
        }

        @Override
        public Builder cluster(String cluster) {
            this.cluster = (String)Preconditions.checkNotNull((Object)cluster, (Object)"cluster");
            return this;
        }

        @Override
        public Builder hosts(Lazy<List<String>> hosts) {
            this.hosts = (Lazy)Preconditions.checkNotNull(hosts, (Object)"hosts");
            return this;
        }

        @Override
        public Builder flushOnWrites(boolean flushOnWrites) {
            this.flushOnWrites = flushOnWrites;
            return this;
        }

        @Override
        public Factory buildFactory() {
            return new Factory(this);
        }
    }
}

