/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import okhttp3.OkHttpClient;
import zipkin2.elasticsearch.AutoValue_ElasticsearchStorage;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.IndexNameFormatter;
import zipkin2.internal.Nullable;

abstract class $AutoValue_ElasticsearchStorage
extends ElasticsearchStorage {
    private final OkHttpClient client;
    private final boolean shutdownClientOnClose;
    private final ElasticsearchStorage.HostsSupplier hostsSupplier;
    private final String pipeline;
    private final boolean flushOnWrites;
    private final int maxRequests;
    private final boolean strictTraceId;
    private final int indexShards;
    private final int indexReplicas;
    private final IndexNameFormatter indexNameFormatter;
    private final int namesLookback;

    $AutoValue_ElasticsearchStorage(OkHttpClient client, boolean shutdownClientOnClose, ElasticsearchStorage.HostsSupplier hostsSupplier, @Nullable String pipeline, boolean flushOnWrites, int maxRequests, boolean strictTraceId, int indexShards, int indexReplicas, IndexNameFormatter indexNameFormatter, int namesLookback) {
        if (client == null) {
            throw new NullPointerException("Null client");
        }
        this.client = client;
        this.shutdownClientOnClose = shutdownClientOnClose;
        if (hostsSupplier == null) {
            throw new NullPointerException("Null hostsSupplier");
        }
        this.hostsSupplier = hostsSupplier;
        this.pipeline = pipeline;
        this.flushOnWrites = flushOnWrites;
        this.maxRequests = maxRequests;
        this.strictTraceId = strictTraceId;
        this.indexShards = indexShards;
        this.indexReplicas = indexReplicas;
        if (indexNameFormatter == null) {
            throw new NullPointerException("Null indexNameFormatter");
        }
        this.indexNameFormatter = indexNameFormatter;
        this.namesLookback = namesLookback;
    }

    @Override
    OkHttpClient client() {
        return this.client;
    }

    @Override
    boolean shutdownClientOnClose() {
        return this.shutdownClientOnClose;
    }

    @Override
    public ElasticsearchStorage.HostsSupplier hostsSupplier() {
        return this.hostsSupplier;
    }

    @Override
    @Nullable
    public String pipeline() {
        return this.pipeline;
    }

    @Override
    public boolean flushOnWrites() {
        return this.flushOnWrites;
    }

    @Override
    public int maxRequests() {
        return this.maxRequests;
    }

    @Override
    public boolean strictTraceId() {
        return this.strictTraceId;
    }

    @Override
    int indexShards() {
        return this.indexShards;
    }

    @Override
    int indexReplicas() {
        return this.indexReplicas;
    }

    @Override
    public IndexNameFormatter indexNameFormatter() {
        return this.indexNameFormatter;
    }

    @Override
    public int namesLookback() {
        return this.namesLookback;
    }

    public String toString() {
        return "ElasticsearchStorage{client=" + this.client + ", shutdownClientOnClose=" + this.shutdownClientOnClose + ", hostsSupplier=" + this.hostsSupplier + ", pipeline=" + this.pipeline + ", flushOnWrites=" + this.flushOnWrites + ", maxRequests=" + this.maxRequests + ", strictTraceId=" + this.strictTraceId + ", indexShards=" + this.indexShards + ", indexReplicas=" + this.indexReplicas + ", indexNameFormatter=" + this.indexNameFormatter + ", namesLookback=" + this.namesLookback + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ElasticsearchStorage) {
            ElasticsearchStorage that = (ElasticsearchStorage)((Object)o);
            return this.client.equals(that.client()) && this.shutdownClientOnClose == that.shutdownClientOnClose() && this.hostsSupplier.equals(that.hostsSupplier()) && (this.pipeline == null ? that.pipeline() == null : this.pipeline.equals(that.pipeline())) && this.flushOnWrites == that.flushOnWrites() && this.maxRequests == that.maxRequests() && this.strictTraceId == that.strictTraceId() && this.indexShards == that.indexShards() && this.indexReplicas == that.indexReplicas() && this.indexNameFormatter.equals(that.indexNameFormatter()) && this.namesLookback == that.namesLookback();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.client.hashCode();
        h *= 1000003;
        h ^= this.shutdownClientOnClose ? 1231 : 1237;
        h *= 1000003;
        h ^= this.hostsSupplier.hashCode();
        h *= 1000003;
        h ^= this.pipeline == null ? 0 : this.pipeline.hashCode();
        h *= 1000003;
        h ^= this.flushOnWrites ? 1231 : 1237;
        h *= 1000003;
        h ^= this.maxRequests;
        h *= 1000003;
        h ^= this.strictTraceId ? 1231 : 1237;
        h *= 1000003;
        h ^= this.indexShards;
        h *= 1000003;
        h ^= this.indexReplicas;
        h *= 1000003;
        h ^= this.indexNameFormatter.hashCode();
        h *= 1000003;
        return h ^= this.namesLookback;
    }

    @Override
    ElasticsearchStorage.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ElasticsearchStorage.Builder {
        private OkHttpClient client;
        private Boolean shutdownClientOnClose;
        private ElasticsearchStorage.HostsSupplier hostsSupplier;
        private String pipeline;
        private Boolean flushOnWrites;
        private Integer maxRequests;
        private Boolean strictTraceId;
        private Integer indexShards;
        private Integer indexReplicas;
        private IndexNameFormatter.Builder indexNameFormatterBuilder$;
        private IndexNameFormatter indexNameFormatter;
        private Integer namesLookback;

        Builder() {
        }

        private Builder(ElasticsearchStorage source) {
            this.client = source.client();
            this.shutdownClientOnClose = source.shutdownClientOnClose();
            this.hostsSupplier = source.hostsSupplier();
            this.pipeline = source.pipeline();
            this.flushOnWrites = source.flushOnWrites();
            this.maxRequests = source.maxRequests();
            this.strictTraceId = source.strictTraceId();
            this.indexShards = source.indexShards();
            this.indexReplicas = source.indexReplicas();
            this.indexNameFormatter = source.indexNameFormatter();
            this.namesLookback = source.namesLookback();
        }

        @Override
        ElasticsearchStorage.Builder client(OkHttpClient client) {
            if (client == null) {
                throw new NullPointerException("Null client");
            }
            this.client = client;
            return this;
        }

        @Override
        public ElasticsearchStorage.Builder shutdownClientOnClose(boolean shutdownClientOnClose) {
            this.shutdownClientOnClose = shutdownClientOnClose;
            return this;
        }

        @Override
        public ElasticsearchStorage.Builder hostsSupplier(ElasticsearchStorage.HostsSupplier hostsSupplier) {
            if (hostsSupplier == null) {
                throw new NullPointerException("Null hostsSupplier");
            }
            this.hostsSupplier = hostsSupplier;
            return this;
        }

        @Override
        public ElasticsearchStorage.Builder pipeline(@Nullable String pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        @Override
        public ElasticsearchStorage.Builder flushOnWrites(boolean flushOnWrites) {
            this.flushOnWrites = flushOnWrites;
            return this;
        }

        @Override
        public ElasticsearchStorage.Builder maxRequests(int maxRequests) {
            this.maxRequests = maxRequests;
            return this;
        }

        @Override
        public ElasticsearchStorage.Builder strictTraceId(boolean strictTraceId) {
            this.strictTraceId = strictTraceId;
            return this;
        }

        @Override
        public ElasticsearchStorage.Builder indexShards(int indexShards) {
            this.indexShards = indexShards;
            return this;
        }

        @Override
        public ElasticsearchStorage.Builder indexReplicas(int indexReplicas) {
            this.indexReplicas = indexReplicas;
            return this;
        }

        @Override
        IndexNameFormatter.Builder indexNameFormatterBuilder() {
            if (this.indexNameFormatterBuilder$ == null) {
                if (this.indexNameFormatter == null) {
                    this.indexNameFormatterBuilder$ = IndexNameFormatter.newBuilder();
                } else {
                    this.indexNameFormatterBuilder$ = this.indexNameFormatter.toBuilder();
                    this.indexNameFormatter = null;
                }
            }
            return this.indexNameFormatterBuilder$;
        }

        @Override
        public ElasticsearchStorage.Builder namesLookback(int namesLookback) {
            this.namesLookback = namesLookback;
            return this;
        }

        @Override
        public ElasticsearchStorage build() {
            if (this.indexNameFormatterBuilder$ != null) {
                this.indexNameFormatter = this.indexNameFormatterBuilder$.build();
            } else if (this.indexNameFormatter == null) {
                IndexNameFormatter.Builder indexNameFormatter$builder = IndexNameFormatter.newBuilder();
                this.indexNameFormatter = indexNameFormatter$builder.build();
            }
            String missing = "";
            if (this.client == null) {
                missing = missing + " client";
            }
            if (this.shutdownClientOnClose == null) {
                missing = missing + " shutdownClientOnClose";
            }
            if (this.hostsSupplier == null) {
                missing = missing + " hostsSupplier";
            }
            if (this.flushOnWrites == null) {
                missing = missing + " flushOnWrites";
            }
            if (this.maxRequests == null) {
                missing = missing + " maxRequests";
            }
            if (this.strictTraceId == null) {
                missing = missing + " strictTraceId";
            }
            if (this.indexShards == null) {
                missing = missing + " indexShards";
            }
            if (this.indexReplicas == null) {
                missing = missing + " indexReplicas";
            }
            if (this.namesLookback == null) {
                missing = missing + " namesLookback";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ElasticsearchStorage(this.client, this.shutdownClientOnClose, this.hostsSupplier, this.pipeline, this.flushOnWrites, this.maxRequests, this.strictTraceId, this.indexShards, this.indexReplicas, this.indexNameFormatter, this.namesLookback);
        }
    }
}

