/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.storage.mysql.v1.DSLContexts;

final class DataSourceCall<V>
extends Call.Base<V> {
    final Factory factory;
    final Function<DSLContext, V> queryFunction;

    DataSourceCall(Factory factory, Function<DSLContext, V> queryFunction) {
        this.factory = factory;
        this.queryFunction = queryFunction;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final V doExecute() throws IOException {
        try (Connection conn = this.factory.datasource.getConnection();){
            DSLContext context = this.factory.context.get(conn);
            V v = this.queryFunction.apply(context);
            return v;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    protected void doEnqueue(final Callback<V> callback) {
        class CallbackRunnable
        implements Runnable {
            CallbackRunnable() {
            }

            @Override
            public void run() {
                try {
                    callback.onSuccess(DataSourceCall.this.doExecute());
                }
                catch (IOException e) {
                    if (e.getCause() instanceof SQLException) {
                        callback.onError(e.getCause());
                    } else {
                        callback.onError((Throwable)e);
                    }
                }
                catch (Throwable t) {
                    Call.propagateIfFatal((Throwable)t);
                    callback.onError(t);
                }
            }
        }
        this.factory.executor.execute(new CallbackRunnable());
    }

    public String toString() {
        return this.queryFunction.toString();
    }

    public Call<V> clone() {
        return new DataSourceCall<V>(this.factory, this.queryFunction);
    }

    static final class Factory {
        final DataSource datasource;
        final DSLContexts context;
        final Executor executor;

        Factory(DataSource datasource, DSLContexts context, Executor executor) {
            this.datasource = datasource;
            this.context = context;
            this.executor = executor;
        }

        <V> DataSourceCall<V> create(Function<DSLContext, V> queryFunction) {
            return new DataSourceCall<V>(this, queryFunction);
        }
    }
}

