/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.stack.NakReceiverWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Buffer;
import org.jgroups.util.Range;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class NAKACK
extends Protocol
implements Retransmitter.RetransmitCommand,
NakReceiverWindow.Listener {
    private long[] retransmit_timeout = new long[]{600L, 1200L, 2400L, 4800L};
    private boolean is_server = false;
    private Address local_addr = null;
    private final Vector members = new Vector(11);
    private View view;
    private long seqno = -1L;
    private long max_xmit_size = 8192L;
    private int gc_lag = 20;
    private boolean use_mcast_xmit = true;
    private boolean xmit_from_random_member = false;
    private boolean discard_delivered_msgs = false;
    private int max_xmit_buf_size = 0;
    private final HashMap received_msgs = new HashMap(11);
    private final TreeMap sent_msgs = new TreeMap();
    private boolean leaving = false;
    private boolean started = false;
    private TimeScheduler timer = null;
    private static final String name = "NAKACK";
    private long xmit_reqs_received;
    private long xmit_reqs_sent;
    private long xmit_rsps_received;
    private long xmit_rsps_sent;
    private long missing_msgs_received;
    private HashMap sent = new HashMap();
    private HashMap received = new HashMap();
    private int stats_list_size = 20;
    private BoundedList receive_history;
    private BoundedList send_history;

    public String getName() {
        return name;
    }

    public long getXmitRequestsReceived() {
        return this.xmit_reqs_received;
    }

    public long getXmitRequestsSent() {
        return this.xmit_reqs_sent;
    }

    public long getXmitResponsesReceived() {
        return this.xmit_rsps_received;
    }

    public long getXmitResponsesSent() {
        return this.xmit_rsps_sent;
    }

    public long getMissingMessagesReceived() {
        return this.missing_msgs_received;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingRetransmissionRequests() {
        int num = 0;
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            Iterator it = this.received_msgs.values().iterator();
            while (it.hasNext()) {
                NakReceiverWindow win = (NakReceiverWindow)it.next();
                num += win.size();
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSentTableSize() {
        int size;
        TreeMap treeMap = this.sent_msgs;
        synchronized (treeMap) {
            size = this.sent_msgs.size();
        }
        return size;
    }

    public int getReceivedTableSize() {
        int ret = 0;
        LinkedHashSet s = new LinkedHashSet(this.received_msgs.values());
        Iterator it = s.iterator();
        while (it.hasNext()) {
            NakReceiverWindow win = (NakReceiverWindow)it.next();
            ret += win.size();
        }
        return ret;
    }

    public void resetStats() {
        this.missing_msgs_received = 0L;
        this.xmit_rsps_sent = 0L;
        this.xmit_rsps_received = 0L;
        this.xmit_reqs_sent = 0L;
        this.xmit_reqs_received = 0L;
        this.sent.clear();
        this.received.clear();
        if (this.receive_history != null) {
            this.receive_history.removeAll();
        }
        if (this.send_history != null) {
            this.send_history.removeAll();
        }
    }

    public void init() throws Exception {
        if (this.stats) {
            this.send_history = new BoundedList(this.stats_list_size);
            this.receive_history = new BoundedList(this.stats_list_size);
        }
    }

    public int getGcLag() {
        return this.gc_lag;
    }

    public void setGcLag(int gc_lag) {
        this.gc_lag = gc_lag;
    }

    public boolean isUseMcastXmit() {
        return this.use_mcast_xmit;
    }

    public void setUseMcastXmit(boolean use_mcast_xmit) {
        this.use_mcast_xmit = use_mcast_xmit;
    }

    public boolean isXmitFromRandomMember() {
        return this.xmit_from_random_member;
    }

    public void setXmitFromRandomMember(boolean xmit_from_random_member) {
        this.xmit_from_random_member = xmit_from_random_member;
    }

    public boolean isDiscardDeliveredMsgs() {
        return this.discard_delivered_msgs;
    }

    public void setDiscardDeliveredMsgs(boolean discard_delivered_msgs) {
        this.discard_delivered_msgs = discard_delivered_msgs;
    }

    public int getMaxXmitBufSize() {
        return this.max_xmit_buf_size;
    }

    public void setMaxXmitBufSize(int max_xmit_buf_size) {
        this.max_xmit_buf_size = max_xmit_buf_size;
    }

    public long getMaxXmitSize() {
        return this.max_xmit_size;
    }

    public void setMaxXmitSize(long max_xmit_size) {
        this.max_xmit_size = max_xmit_size;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("retransmit_timeout");
        if (str != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            props.remove("retransmit_timeout");
            if (tmp != null && tmp.length > 0) {
                this.retransmit_timeout = tmp;
            }
        }
        if ((str = props.getProperty("gc_lag")) != null) {
            this.gc_lag = Integer.parseInt(str);
            if (this.gc_lag < 0) {
                this.log.error((Object)"NAKACK.setProperties(): gc_lag cannot be negative, setting it to 0");
            }
            props.remove("gc_lag");
        }
        if ((str = props.getProperty("max_xmit_size")) != null) {
            this.max_xmit_size = Long.parseLong(str);
            props.remove("max_xmit_size");
        }
        if ((str = props.getProperty("use_mcast_xmit")) != null) {
            this.use_mcast_xmit = Boolean.valueOf(str);
            props.remove("use_mcast_xmit");
        }
        if ((str = props.getProperty("discard_delivered_msgs")) != null) {
            this.discard_delivered_msgs = Boolean.valueOf(str);
            props.remove("discard_delivered_msgs");
        }
        if ((str = props.getProperty("xmit_from_random_member")) != null) {
            this.xmit_from_random_member = Boolean.valueOf(str);
            props.remove("xmit_from_random_member");
        }
        if ((str = props.getProperty("max_xmit_buf_size")) != null) {
            this.max_xmit_buf_size = Integer.parseInt(str);
            props.remove("max_xmit_buf_size");
        }
        if ((str = props.getProperty("stats_list_size")) != null) {
            this.stats_list_size = Integer.parseInt(str);
            props.remove("stats_list_size");
        }
        if (this.xmit_from_random_member && this.discard_delivered_msgs) {
            this.discard_delivered_msgs = false;
            this.log.warn((Object)"xmit_from_random_member set to true: changed discard_delivered_msgs to false");
        }
        if (props.size() > 0) {
            this.log.error((Object)("NAKACK.setProperties(): these properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map dumpStats() {
        HashMap<String, Long> retval = super.dumpStats();
        if (retval == null) {
            retval = new HashMap<String, Long>();
        }
        retval.put("xmit_reqs_received", new Long(this.xmit_reqs_received));
        retval.put("xmit_reqs_sent", new Long(this.xmit_reqs_sent));
        retval.put("xmit_rsps_received", new Long(this.xmit_rsps_received));
        retval.put("xmit_rsps_sent", new Long(this.xmit_rsps_sent));
        retval.put("missing_msgs_received", new Long(this.missing_msgs_received));
        retval.put("sent_msgs", (Long)((Object)this.printSentMsgs()));
        StringBuffer sb = new StringBuffer();
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            Iterator it = this.received_msgs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Address addr = (Address)entry.getKey();
                Object w = entry.getValue();
                sb.append(addr).append(": ").append(w.toString()).append('\n');
            }
        }
        retval.put("received_msgs", (Long)((Object)sb.toString()));
        return retval;
    }

    public String printStats() {
        Object val;
        Object key;
        Map.Entry entry;
        StringBuffer sb = new StringBuffer();
        sb.append("sent:\n");
        Iterator it = this.sent.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            key = entry.getKey();
            if (key == null) {
                key = "<mcast dest>";
            }
            val = entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
        sb.append("\nreceived:\n");
        it = this.received.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            key = entry.getKey();
            val = entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
        sb.append("\nXMIT_REQS sent:\n");
        Enumeration en = this.send_history.elements();
        while (en.hasMoreElements()) {
            XmitRequest tmp = (XmitRequest)en.nextElement();
            sb.append(tmp).append("\n");
        }
        sb.append("\nMissing messages received\n");
        Enumeration en2 = this.receive_history.elements();
        while (en2.hasMoreElements()) {
            MissingMessage missing = (MissingMessage)en2.nextElement();
            sb.append(missing).append("\n");
        }
        return sb.toString();
    }

    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>(5);
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(57));
        retval.addElement(new Integer(42));
        retval.addElement(new Integer(41));
        retval.addElement(new Integer(53));
        return retval;
    }

    public Vector providedDownServices() {
        Vector<Integer> retval = new Vector<Integer>(2);
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(57));
        return retval;
    }

    public void start() throws Exception {
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        this.started = true;
    }

    public void stop() {
        this.started = false;
        this.reset();
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest != null && !dest.isMulticastAddress()) break;
                this.send(evt, msg);
                return;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return;
            }
            case 39: {
                Digest digest = this.getDigest();
                this.passUp(new Event(40, digest != null ? digest.copy() : null));
                return;
            }
            case 57: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passUp(new Event(58, digest != null ? digest.copy() : null));
                return;
            }
            case 42: {
                Digest digest = this.getDigest();
                this.passUp(new Event(43, digest != null ? digest.copy() : null));
                return;
            }
            case 41: {
                this.setDigest((Digest)evt.getArg());
                return;
            }
            case 53: {
                this.mergeDigest((Digest)evt.getArg());
                return;
            }
            case 56: {
                this.passDown(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
            case 15: {
                View tmp_view = (View)evt.getArg();
                Vector mbrs = tmp_view.getMembers();
                this.members.clear();
                this.members.addAll(mbrs);
                this.adjustReceivers(false);
                break;
            }
            case 6: {
                View tmp_view = (View)evt.getArg();
                Vector mbrs = tmp_view.getMembers();
                this.members.clear();
                this.members.addAll(mbrs);
                this.adjustReceivers(true);
                this.is_server = true;
                LinkedHashSet<Object> tmp = new LinkedHashSet<Object>(this.members);
                tmp.add(null);
                this.sent.keySet().retainAll(tmp);
                this.received.keySet().retainAll(tmp);
                this.view = tmp_view;
                break;
            }
            case 16: {
                this.is_server = true;
                break;
            }
            case 4: {
                this.leaving = true;
                this.reset();
            }
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                NakAckHeader hdr = (NakAckHeader)msg.getHeader(name);
                if (hdr == null) break;
                if (!this.is_server) {
                    if (this.trace) {
                        this.log.trace((Object)"message was discarded (not yet server)");
                    }
                    return;
                }
                switch (hdr.type) {
                    case 1: {
                        this.handleMessage(msg, hdr);
                        return;
                    }
                    case 2: {
                        if (hdr.range == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)("XMIT_REQ: range of xmit msg is null; discarding request from " + msg.getSrc()));
                            }
                            return;
                        }
                        this.handleXmitReq(msg.getSrc(), hdr.range.low, hdr.range.high, hdr.sender);
                        return;
                    }
                    case 3: {
                        if (this.trace) {
                            this.log.trace((Object)("received missing messages " + hdr.range));
                        }
                        this.handleXmitRsp(msg);
                        return;
                    }
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("NakAck header type " + hdr.type + " not known !"));
                }
                return;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return;
            }
            case 39: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passDown(new Event(40, digest));
                return;
            }
            case 57: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passDown(new Event(58, digest));
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 56: {
                this.passUp(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Event evt, Message msg) {
        block13: {
            long msg_id;
            if (msg == null) {
                throw new NullPointerException("msg is null; event is " + evt);
            }
            if (!this.started) {
                if (this.warn) {
                    this.log.warn((Object)("[" + this.local_addr + "] discarded message as start() has not been called, message: " + msg));
                }
                return;
            }
            TreeMap treeMap = this.sent_msgs;
            synchronized (treeMap) {
                try {
                    msg_id = this.seqno + 1L;
                    msg.putHeader(name, new NakAckHeader(1, msg_id));
                    this.sent_msgs.put(new Long(msg_id), msg);
                    this.seqno = msg_id;
                }
                catch (Throwable t) {
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException("failure adding msg " + msg + " to the retransmit table", t);
                }
            }
            try {
                if (this.trace) {
                    this.log.trace((Object)("sending " + this.local_addr + "#" + msg_id));
                }
                this.passDown(evt);
            }
            catch (Throwable t) {
                if (!this.warn) break block13;
                this.log.warn((Object)"failure passing message down", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(Message msg, NakAckHeader hdr) {
        NakReceiverWindow win;
        Serializable sb;
        Address sender = msg.getSrc();
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender of message is null");
            }
            return;
        }
        if (this.trace) {
            sb = new StringBuffer(91);
            ((StringBuffer)sb).append(this.local_addr).append(": received ").append(sender).append('#').append(hdr.seqno);
            this.log.trace((Object)((StringBuffer)sb).toString());
        }
        sb = this.received_msgs;
        synchronized (sb) {
            win = (NakReceiverWindow)this.received_msgs.get(sender);
        }
        if (win == null) {
            if (this.leaving) {
                return;
            }
            if (this.warn) {
                sb = new StringBuffer(91);
                ((StringBuffer)sb).append(this.local_addr).append("] discarded message from non-member ").append(sender).append(", my view is ").append(this.view);
                this.log.warn((Object)sb);
            }
            return;
        }
        win.add(hdr.seqno, msg);
        NakReceiverWindow nakReceiverWindow = win;
        synchronized (nakReceiverWindow) {
            Message msg_to_deliver;
            while ((msg_to_deliver = win.remove()) != null) {
                this.passUp(new Event(1, msg_to_deliver));
            }
        }
    }

    private void handleXmitReq(Address xmit_requester, long first_seqno, long last_seqno, Address original_sender) {
        boolean amISender;
        long size = 0L;
        long marker = first_seqno;
        NakReceiverWindow win = null;
        if (this.trace) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.local_addr).append(": received xmit request from ").append(xmit_requester).append(" for ");
            sb.append(original_sender).append(" [").append(first_seqno).append(" - ").append(last_seqno).append("]");
            this.log.trace((Object)sb.toString());
        }
        if (first_seqno > last_seqno) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("first_seqno (" + first_seqno + ") > last_seqno (" + last_seqno + "): not able to retransmit"));
            }
            return;
        }
        if (this.stats) {
            this.xmit_reqs_received += last_seqno - first_seqno + 1L;
            NAKACK.updateStats(this.received, xmit_requester, 1, 0, 0);
        }
        if (!(amISender = this.local_addr.equals(original_sender))) {
            win = (NakReceiverWindow)this.received_msgs.get(original_sender);
        }
        LinkedList<Message> list = new LinkedList<Message>();
        for (long i = first_seqno; i <= last_seqno; ++i) {
            Message tmp;
            Message m;
            if (amISender) {
                m = (Message)this.sent_msgs.get(new Long(i));
            } else {
                Message message = m = win != null ? win.get(i) : null;
            }
            if (m == null) {
                if (!this.log.isErrorEnabled()) continue;
                StringBuffer sb = new StringBuffer();
                sb.append("(requester=").append(xmit_requester).append(", local_addr=").append(this.local_addr);
                sb.append(") message ").append(original_sender).append("::").append(i);
                sb.append(" not found in ").append(amISender ? "sent" : "received").append(" msgs. ");
                if (win != null) {
                    sb.append("Received messages from ").append(original_sender).append(": ").append(win.toString());
                } else {
                    sb.append("\nSent messages: ").append(this.printSentMsgs());
                }
                this.log.error((Object)sb);
                continue;
            }
            long len = m.size();
            if ((size += len) > this.max_xmit_size && list.size() > 0) {
                if (this.trace) {
                    this.log.trace((Object)("xmitting msgs [" + marker + '-' + (i - 1L) + "] to " + xmit_requester));
                }
                this.sendXmitRsp(xmit_requester, (LinkedList)list.clone(), marker, i - 1L);
                marker = i;
                list.clear();
                size = len;
            }
            if ((tmp = m).getSrc() == null) {
                tmp.setSrc(this.local_addr);
            }
            list.add(tmp);
        }
        if (list.size() > 0) {
            if (this.trace) {
                this.log.trace((Object)("xmitting msgs [" + marker + '-' + last_seqno + "] to " + xmit_requester));
            }
            this.sendXmitRsp(xmit_requester, (LinkedList)list.clone(), marker, last_seqno);
            list.clear();
        }
    }

    private static void updateStats(HashMap map, Address key, int req, int rsp, int missing) {
        Entry entry = (Entry)map.get(key);
        if (entry == null) {
            entry = new Entry();
            map.put(key, entry);
        }
        entry.xmit_reqs += (long)req;
        entry.xmit_rsps += (long)rsp;
        entry.missing_msgs_rcvd += (long)missing;
    }

    private void sendXmitRsp(Address dest, LinkedList xmit_list, long first_seqno, long last_seqno) {
        if (xmit_list == null || xmit_list.size() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"xmit_list is empty");
            }
            return;
        }
        if (this.use_mcast_xmit) {
            dest = null;
        }
        if (this.stats) {
            this.xmit_rsps_sent += (long)xmit_list.size();
            NAKACK.updateStats(this.sent, dest, 0, 1, 0);
        }
        try {
            Buffer buf = Util.msgListToByteBuffer(xmit_list);
            Message msg = new Message(dest, null, buf.getBuf(), buf.getOffset(), buf.getLength());
            msg.putHeader(name, new NakAckHeader(3, first_seqno, last_seqno));
            this.passDown(new Event(1, msg));
        }
        catch (IOException ex) {
            this.log.error((Object)"failed marshalling xmit list", (Throwable)ex);
        }
    }

    private void handleXmitRsp(Message msg) {
        block7: {
            if (msg == null) {
                if (this.warn) {
                    this.log.warn((Object)"message is null");
                }
                return;
            }
            try {
                LinkedList list = Util.byteBufferToMessageList(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
                if (list != null) {
                    if (this.stats) {
                        this.xmit_rsps_received += (long)list.size();
                        NAKACK.updateStats(this.received, msg.getSrc(), 0, 1, 0);
                    }
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        Message m = (Message)it.next();
                        this.up(new Event(1, m));
                    }
                    list.clear();
                }
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block7;
                this.log.error((Object)"failed reading list of retransmitted messages", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustReceivers(boolean remove) {
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            NakReceiverWindow win;
            Address sender;
            if (remove) {
                Iterator it = this.received_msgs.keySet().iterator();
                while (it.hasNext()) {
                    sender = (Address)it.next();
                    if (this.members.contains(sender)) continue;
                    win = (NakReceiverWindow)this.received_msgs.get(sender);
                    win.reset();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("removing " + sender + " from received_msgs (not member anymore)"));
                    }
                    it.remove();
                }
            }
            for (int i = 0; i < this.members.size(); ++i) {
                sender = (Address)this.members.elementAt(i);
                if (this.received_msgs.containsKey(sender)) continue;
                win = this.createNakReceiverWindow(sender, 0L);
                this.received_msgs.put(sender, win);
            }
        }
    }

    private Digest getDigest() {
        Digest digest = new Digest(this.members.size());
        for (int i = 0; i < this.members.size(); ++i) {
            Address sender = (Address)this.members.elementAt(i);
            Range range = this.getLowestAndHighestSeqno(sender, false);
            if (range == null) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"range is null");
                continue;
            }
            digest.add(sender, range.low, range.high);
        }
        return digest;
    }

    private Digest getDigestHighestDeliveredMsgs() {
        Digest digest = new Digest(this.members.size());
        for (int i = 0; i < this.members.size(); ++i) {
            Address sender = (Address)this.members.elementAt(i);
            Range range = this.getLowestAndHighestSeqno(sender, true);
            if (range == null) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"range is null");
                continue;
            }
            long high_seqno_seen = this.getHighSeqnoSeen(sender);
            digest.add(sender, range.low, range.high, high_seqno_seen);
        }
        return digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDigest(Digest d) {
        if (d == null || d.senders == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"digest or digest.senders is null");
            }
            return;
        }
        this.clear();
        Iterator it = d.senders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Address sender = (Address)entry.getKey();
            Digest.Entry val = (Digest.Entry)entry.getValue();
            if (sender == null || val == null) {
                if (!this.warn) continue;
                this.log.warn((Object)"sender or value is null");
                continue;
            }
            long initial_seqno = val.high_seqno;
            NakReceiverWindow win = this.createNakReceiverWindow(sender, initial_seqno);
            HashMap hashMap = this.received_msgs;
            synchronized (hashMap) {
                this.received_msgs.put(sender, win);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeDigest(Digest d) {
        if (d == null || d.senders == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"digest or digest.senders is null");
            }
            return;
        }
        Iterator it = d.senders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Address sender = (Address)entry.getKey();
            Digest.Entry val = (Digest.Entry)entry.getValue();
            if (sender == null || val == null) {
                if (!this.warn) continue;
                this.log.warn((Object)"sender or value is null");
                continue;
            }
            long initial_seqno = val.high_seqno;
            HashMap hashMap = this.received_msgs;
            synchronized (hashMap) {
                NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(sender);
                if (win == null) {
                    win = this.createNakReceiverWindow(sender, initial_seqno);
                    this.received_msgs.put(sender, win);
                } else if (win.getHighestReceived() < initial_seqno) {
                    win.reset();
                    this.received_msgs.remove(sender);
                    win = this.createNakReceiverWindow(sender, initial_seqno);
                    this.received_msgs.put(sender, win);
                }
            }
        }
    }

    private NakReceiverWindow createNakReceiverWindow(Address sender, long initial_seqno) {
        NakReceiverWindow win = new NakReceiverWindow(sender, this, initial_seqno, this.timer);
        win.setRetransmitTimeouts(this.retransmit_timeout);
        win.setDiscardDeliveredMessages(this.discard_delivered_msgs);
        win.setMaxXmitBufSize(this.max_xmit_buf_size);
        if (this.stats) {
            win.setListener(this);
        }
        return win;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Range getLowestAndHighestSeqno(Address sender, boolean stop_at_gaps) {
        NakReceiverWindow win;
        Range r = null;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender is null");
            }
            return r;
        }
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            win = (NakReceiverWindow)this.received_msgs.get(sender);
        }
        if (win == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("sender " + sender + " not found in received_msgs"));
            }
            return r;
        }
        r = stop_at_gaps ? new Range(win.getLowestSeen(), win.getHighestSeen()) : new Range(win.getLowestSeen(), win.getHighestReceived() + 1L);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getHighSeqnoSeen(Address sender) {
        NakReceiverWindow win;
        long ret = 0L;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender is null");
            }
            return ret;
        }
        if (sender.equals(this.local_addr)) {
            return this.seqno - 1L;
        }
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            win = (NakReceiverWindow)this.received_msgs.get(sender);
        }
        if (win == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("sender " + sender + " not found in received_msgs"));
            }
            return ret;
        }
        ret = win.getHighestReceived();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stable(Digest d) {
        if (this.members == null || this.local_addr == null || d == null) {
            if (this.warn) {
                this.log.warn((Object)"members, local_addr or digest are null !");
            }
            return;
        }
        if (this.trace) {
            this.log.trace((Object)("received stable digest " + d));
        }
        Iterator it = d.senders.entrySet().iterator();
        while (it.hasNext()) {
            NakReceiverWindow recv_win;
            Map.Entry entry = it.next();
            Address sender = (Address)entry.getKey();
            if (sender == null) continue;
            Digest.Entry val = (Digest.Entry)entry.getValue();
            long high_seqno_delivered = val.high_seqno;
            long high_seqno_received = val.high_seqno_seen;
            AbstractMap abstractMap = this.received_msgs;
            synchronized (abstractMap) {
                recv_win = (NakReceiverWindow)this.received_msgs.get(sender);
            }
            if (recv_win != null) {
                long my_highest_rcvd = recv_win.getHighestReceived();
                long stability_highest_rcvd = high_seqno_received;
                if (stability_highest_rcvd >= 0L && stability_highest_rcvd > my_highest_rcvd) {
                    if (this.trace) {
                        this.log.trace((Object)("my_highest_rcvd (" + my_highest_rcvd + ") < stability_highest_rcvd (" + stability_highest_rcvd + "): requesting retransmission of " + sender + '#' + stability_highest_rcvd));
                    }
                    this.retransmit(stability_highest_rcvd, stability_highest_rcvd, sender);
                }
            }
            if ((high_seqno_delivered -= (long)this.gc_lag) < 0L) continue;
            if (this.trace) {
                this.log.trace((Object)("deleting msgs <= " + high_seqno_delivered + " from " + sender));
            }
            if (sender.equals(this.local_addr)) {
                abstractMap = this.sent_msgs;
                synchronized (abstractMap) {
                    SortedMap stable_keys = this.sent_msgs.headMap(new Long(high_seqno_delivered));
                    if (stable_keys != null) {
                        stable_keys.clear();
                    }
                }
            }
            if (recv_win == null) continue;
            recv_win.stable(high_seqno_delivered);
        }
    }

    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        Address random_member;
        Address dest = sender;
        if (this.xmit_from_random_member && !this.local_addr.equals(sender) && (random_member = (Address)Util.pickRandomElement(this.members)) != null && !this.local_addr.equals(random_member)) {
            dest = random_member;
            if (this.trace) {
                this.log.trace((Object)("picked random member " + dest + " to send XMIT request to"));
            }
        }
        NakAckHeader hdr = new NakAckHeader(2, first_seqno, last_seqno, sender);
        Message retransmit_msg = new Message(dest, null, null);
        if (this.trace) {
            this.log.trace((Object)(this.local_addr + ": sending XMIT_REQ ([" + first_seqno + ", " + last_seqno + "]) to " + dest));
        }
        retransmit_msg.putHeader(name, hdr);
        this.passDown(new Event(1, retransmit_msg));
        if (this.stats) {
            this.xmit_reqs_sent += last_seqno - first_seqno + 1L;
            NAKACK.updateStats(this.sent, dest, 1, 0, 0);
            for (long i = first_seqno; i <= last_seqno; ++i) {
                XmitRequest req = new XmitRequest(sender, i, dest);
                this.send_history.add(req);
            }
        }
    }

    public void missingMessageReceived(long seqno, Message msg) {
        if (this.stats) {
            ++this.missing_msgs_received;
            NAKACK.updateStats(this.received, msg.getSrc(), 0, 0, 1);
            MissingMessage missing = new MissingMessage(msg.getSrc(), seqno);
            this.receive_history.add(missing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            Iterator it = this.received_msgs.values().iterator();
            while (it.hasNext()) {
                NakReceiverWindow win = (NakReceiverWindow)it.next();
                win.reset();
            }
            this.received_msgs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        AbstractMap abstractMap = this.sent_msgs;
        synchronized (abstractMap) {
            this.sent_msgs.clear();
            this.seqno = -1L;
        }
        abstractMap = this.received_msgs;
        synchronized (abstractMap) {
            Iterator it = this.received_msgs.values().iterator();
            while (it.hasNext()) {
                NakReceiverWindow win = (NakReceiverWindow)it.next();
                win.destroy();
            }
            this.received_msgs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printMessages() {
        StringBuffer ret = new StringBuffer();
        ret.append("\nsent_msgs: ").append(this.printSentMsgs());
        ret.append("\nreceived_msgs:\n");
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            Iterator it = this.received_msgs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Address addr = (Address)entry.getKey();
                Object w = entry.getValue();
                ret.append(addr).append(": ").append(w.toString()).append('\n');
            }
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printSentMsgs() {
        Long max_seqno;
        Long min_seqno;
        StringBuffer sb = new StringBuffer();
        TreeMap treeMap = this.sent_msgs;
        synchronized (treeMap) {
            min_seqno = this.sent_msgs.size() > 0 ? (Long)this.sent_msgs.firstKey() : new Long(0L);
            max_seqno = this.sent_msgs.size() > 0 ? (Long)this.sent_msgs.lastKey() : new Long(0L);
        }
        sb.append('[').append(min_seqno).append(" - ").append(max_seqno).append("] (").append(this.sent_msgs.size()).append(")");
        return sb.toString();
    }

    private void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("frag_size")) {
            this.max_xmit_size = ((Integer)map.get("frag_size")).intValue();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("max_xmit_size=" + this.max_xmit_size));
            }
        }
    }

    static class MissingMessage {
        Address original_sender;
        long seq;
        long timestamp = System.currentTimeMillis();

        MissingMessage(Address original_sender, long seqno) {
            this.original_sender = original_sender;
            this.seq = seqno;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(new Date(this.timestamp)).append(": ").append(this.original_sender).append(" #").append(this.seq);
            return sb.toString();
        }
    }

    static class XmitRequest {
        Address original_sender;
        long seq;
        long timestamp = System.currentTimeMillis();
        Address xmit_dest;

        XmitRequest(Address original_sender, long seqno, Address xmit_dest) {
            this.original_sender = original_sender;
            this.xmit_dest = xmit_dest;
            this.seq = seqno;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(new Date(this.timestamp)).append(": ").append(this.original_sender).append(" #").append(this.seq);
            sb.append(" (XMIT_REQ sent to ").append(this.xmit_dest).append(")");
            return sb.toString();
        }
    }

    static class Entry {
        long xmit_reqs;
        long xmit_rsps;
        long missing_msgs_rcvd;

        Entry() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.xmit_reqs).append(" xmit_reqs").append(", ").append(this.xmit_rsps).append(" xmit_rsps");
            sb.append(", ").append(this.missing_msgs_rcvd).append(" missing msgs");
            return sb.toString();
        }
    }
}

