/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.util.UnmodifiableVector;

public class UnmodifiableVectorTest
extends TestCase {
    Vector v;
    UnmodifiableVector uv;

    public UnmodifiableVectorTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.v = new Vector();
        this.v.add("one");
        this.v.add("two");
        this.uv = new UnmodifiableVector(this.v);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreation() {
        UnmodifiableVectorTest.assertEquals((int)this.v.size(), (int)this.uv.size());
        UnmodifiableVectorTest.assertTrue((boolean)this.uv.contains("two"));
    }

    public void testAddition() {
        try {
            this.uv.add("three");
            UnmodifiableVectorTest.fail((String)"should throw an exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRemoval() {
        try {
            this.uv.add("two");
            UnmodifiableVectorTest.fail((String)"should throw an exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testIteration() {
        Object el;
        Iterator it = this.uv.iterator();
        while (it.hasNext()) {
            el = it.next();
            System.out.println(el);
        }
        it = this.uv.iterator();
        while (it.hasNext()) {
            el = it.next();
            try {
                it.remove();
                UnmodifiableVectorTest.fail((String)"should throw exception");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public void testListIteration() {
        Object el;
        ListIterator it = this.uv.listIterator();
        while (it.hasNext()) {
            el = it.next();
            System.out.println(el);
        }
        it = this.uv.listIterator();
        while (it.hasNext()) {
            el = it.next();
            try {
                it.remove();
                UnmodifiableVectorTest.fail((String)"should throw exception");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{UnmodifiableVectorTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }
}

