/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import me.zhanghai.android.materialprogressbar.BaseSingleHorizontalProgressDrawable;
import me.zhanghai.android.materialprogressbar.ShowBackgroundDrawable;

class SingleHorizontalProgressDrawable
extends BaseSingleHorizontalProgressDrawable
implements ShowBackgroundDrawable {
    private static final int LEVEL_MAX = 10000;
    private boolean mShowBackground;

    public SingleHorizontalProgressDrawable(@NonNull Context context) {
        super(context);
    }

    protected boolean onLevelChange(@IntRange(from=0L, to=10000L) int level) {
        this.invalidateSelf();
        return true;
    }

    @Override
    public boolean getShowBackground() {
        return this.mShowBackground;
    }

    @Override
    public void setShowBackground(boolean show) {
        if (this.mShowBackground != show) {
            this.mShowBackground = show;
            this.invalidateSelf();
        }
    }

    @Override
    protected void onDrawRect(@NonNull Canvas canvas, @NonNull Paint paint) {
        int level = this.getLevel();
        if (level == 0) {
            return;
        }
        int saveCount = canvas.save();
        canvas.scale((float)level / 10000.0f, 1.0f, SingleHorizontalProgressDrawable.RECT_BOUND.left, 0.0f);
        super.onDrawRect(canvas, paint);
        if (this.mShowBackground) {
            super.onDrawRect(canvas, paint);
        }
        canvas.restoreToCount(saveCount);
    }
}

