/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar.internal;

import android.content.res.Resources;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import me.zhanghai.android.materialprogressbar.internal.DrawableContainerCompat;
import me.zhanghai.android.materialprogressbar.internal.ValueAnimatorCompat;

public class AnimationScaleListDrawableCompat
extends DrawableContainerCompat
implements Animatable {
    private static final String TAG = "AnimationScaleListDrawableCompat";
    private AnimationScaleListState mAnimationScaleListState;
    private boolean mMutated;

    public AnimationScaleListDrawableCompat(@NonNull Drawable[] drawables) {
        this.setConstantState(new AnimationScaleListState(null, this, null));
        for (Drawable drawable : drawables) {
            this.mAnimationScaleListState.addDrawable(drawable);
        }
        this.onStateChange(this.getState());
    }

    private AnimationScaleListDrawableCompat(@Nullable AnimationScaleListState state, @Nullable Resources res) {
        AnimationScaleListState newState = new AnimationScaleListState(state, this, res);
        this.setConstantState(newState);
        this.onStateChange(this.getState());
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        int idx = this.mAnimationScaleListState.getCurrentDrawableIndexBasedOnScale();
        return this.selectDrawable(idx) || changed;
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mAnimationScaleListState.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    public void start() {
        Drawable dr = this.getCurrent();
        if (dr != null && dr instanceof Animatable) {
            ((Animatable)dr).start();
        }
    }

    public void stop() {
        Drawable dr = this.getCurrent();
        if (dr != null && dr instanceof Animatable) {
            ((Animatable)dr).stop();
        }
    }

    public boolean isRunning() {
        boolean result = false;
        Drawable dr = this.getCurrent();
        if (dr != null && dr instanceof Animatable) {
            result = ((Animatable)dr).isRunning();
        }
        return result;
    }

    @Override
    @RequiresApi(value=21)
    public void applyTheme(@NonNull Resources.Theme theme) {
        super.applyTheme(theme);
        this.onStateChange(this.getState());
    }

    @Override
    protected void setConstantState(@NonNull DrawableContainerCompat.DrawableContainerState state) {
        super.setConstantState(state);
        if (state instanceof AnimationScaleListState) {
            this.mAnimationScaleListState = (AnimationScaleListState)state;
        }
    }

    static class AnimationScaleListState
    extends DrawableContainerCompat.DrawableContainerState {
        int[] mThemeAttrs = null;
        int mStaticDrawableIndex = -1;
        int mAnimatableDrawableIndex = -1;

        AnimationScaleListState(AnimationScaleListState orig, AnimationScaleListDrawableCompat owner, Resources res) {
            super(orig, owner, res);
            if (orig != null) {
                this.mThemeAttrs = orig.mThemeAttrs;
                this.mStaticDrawableIndex = orig.mStaticDrawableIndex;
                this.mAnimatableDrawableIndex = orig.mAnimatableDrawableIndex;
            }
        }

        @Override
        void mutate() {
            this.mThemeAttrs = this.mThemeAttrs != null ? (int[])this.mThemeAttrs.clone() : null;
        }

        int addDrawable(Drawable drawable) {
            int pos = this.addChild(drawable);
            if (drawable instanceof Animatable) {
                this.mAnimatableDrawableIndex = pos;
            } else {
                this.mStaticDrawableIndex = pos;
            }
            return pos;
        }

        public Drawable newDrawable() {
            return new AnimationScaleListDrawableCompat(this, null);
        }

        public Drawable newDrawable(Resources res) {
            return new AnimationScaleListDrawableCompat(this, res);
        }

        @Override
        @RequiresApi(value=21)
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null || super.canApplyTheme();
        }

        public int getCurrentDrawableIndexBasedOnScale() {
            if (!ValueAnimatorCompat.areAnimatorsEnabled()) {
                return this.mStaticDrawableIndex;
            }
            return this.mAnimatableDrawableIndex;
        }
    }
}

