/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar.internal;

import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TypeEvaluator;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.util.Property;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;

class ObjectAnimatorCompatBase {
    private static final int NUM_POINTS = 201;

    private ObjectAnimatorCompatBase() {
    }

    @NonNull
    public static ObjectAnimator ofArgb(@Nullable Object target, @NonNull String propertyName, int ... values) {
        ObjectAnimator animator = ObjectAnimator.ofInt((Object)target, (String)propertyName, (int[])values);
        animator.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        return animator;
    }

    @NonNull
    public static <T> ObjectAnimator ofArgb(@Nullable T target, @NonNull Property<T, Integer> property, int ... values) {
        ObjectAnimator animator = ObjectAnimator.ofInt(target, property, (int[])values);
        animator.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        return animator;
    }

    @NonNull
    public static ObjectAnimator ofFloat(@Nullable Object target, @NonNull String xPropertyName, @NonNull String yPropertyName, @NonNull Path path) {
        float[] xValues = new float[201];
        float[] yValues = new float[201];
        ObjectAnimatorCompatBase.calculateXYValues(path, xValues, yValues);
        PropertyValuesHolder xPvh = PropertyValuesHolder.ofFloat((String)xPropertyName, (float[])xValues);
        PropertyValuesHolder yPvh = PropertyValuesHolder.ofFloat((String)yPropertyName, (float[])yValues);
        return ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])new PropertyValuesHolder[]{xPvh, yPvh});
    }

    @NonNull
    public static <T> ObjectAnimator ofFloat(@Nullable T target, @NonNull Property<T, Float> xProperty, @NonNull Property<T, Float> yProperty, @NonNull Path path) {
        float[] xValues = new float[201];
        float[] yValues = new float[201];
        ObjectAnimatorCompatBase.calculateXYValues(path, xValues, yValues);
        PropertyValuesHolder xPvh = PropertyValuesHolder.ofFloat(xProperty, (float[])xValues);
        PropertyValuesHolder yPvh = PropertyValuesHolder.ofFloat(yProperty, (float[])yValues);
        return ObjectAnimator.ofPropertyValuesHolder(target, (PropertyValuesHolder[])new PropertyValuesHolder[]{xPvh, yPvh});
    }

    @NonNull
    public static ObjectAnimator ofInt(@Nullable Object target, @NonNull String xPropertyName, @NonNull String yPropertyName, @NonNull Path path) {
        int[] xValues = new int[201];
        int[] yValues = new int[201];
        ObjectAnimatorCompatBase.calculateXYValues(path, xValues, yValues);
        PropertyValuesHolder xPvh = PropertyValuesHolder.ofInt((String)xPropertyName, (int[])xValues);
        PropertyValuesHolder yPvh = PropertyValuesHolder.ofInt((String)yPropertyName, (int[])yValues);
        return ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])new PropertyValuesHolder[]{xPvh, yPvh});
    }

    @NonNull
    public static <T> ObjectAnimator ofInt(@Nullable T target, @NonNull Property<T, Integer> xProperty, @NonNull Property<T, Integer> yProperty, @NonNull Path path) {
        int[] xValues = new int[201];
        int[] yValues = new int[201];
        ObjectAnimatorCompatBase.calculateXYValues(path, xValues, yValues);
        PropertyValuesHolder xPvh = PropertyValuesHolder.ofInt(xProperty, (int[])xValues);
        PropertyValuesHolder yPvh = PropertyValuesHolder.ofInt(yProperty, (int[])yValues);
        return ObjectAnimator.ofPropertyValuesHolder(target, (PropertyValuesHolder[])new PropertyValuesHolder[]{xPvh, yPvh});
    }

    private static void calculateXYValues(@NonNull Path path, @NonNull @Size(value=201L) float[] xValues, @NonNull @Size(value=201L) float[] yValues) {
        PathMeasure pathMeasure = new PathMeasure(path, false);
        float pathLength = pathMeasure.getLength();
        float[] position = new float[2];
        for (int i = 0; i < 201; ++i) {
            float distance = (float)i * pathLength / 200.0f;
            pathMeasure.getPosTan(distance, position, null);
            xValues[i] = position[0];
            yValues[i] = position[1];
        }
    }

    private static void calculateXYValues(@NonNull Path path, @NonNull @Size(value=201L) int[] xValues, @NonNull @Size(value=201L) int[] yValues) {
        PathMeasure pathMeasure = new PathMeasure(path, false);
        float pathLength = pathMeasure.getLength();
        float[] position = new float[2];
        for (int i = 0; i < 201; ++i) {
            float distance = (float)i * pathLength / 200.0f;
            pathMeasure.getPosTan(distance, position, null);
            xValues[i] = Math.round(position[0]);
            yValues[i] = Math.round(position[1]);
        }
    }
}

