/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.geo;

public class GeoUtil {
    public static final double EARTH_RADIUS = 6378137.0;

    public static double getDistance(double lng1, double lat1, double lng2, double lat2) {
        double radLat1 = GeoUtil.radian(lat1);
        double radLat2 = GeoUtil.radian(lat2);
        double a = radLat1 - radLat2;
        double b = GeoUtil.radian(lng1) - GeoUtil.radian(lng2);
        return 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0))) * 6378137.0;
    }

    public static double getGpsValue(int coordinate) {
        int degrees = coordinate / 360000;
        int remainder = coordinate % 360000;
        int minutes = remainder / 6000;
        double seconds = (double)(remainder %= 6000) / 100.0;
        return (double)degrees + (double)minutes / 60.0 + seconds / 3600.0;
    }

    private static double radian(double d) {
        return d * Math.PI / 180.0;
    }
}

