/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.people.biz.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.people.biz.IPeopleBiz;
import net.mingsoft.people.dao.IPeopleDao;
import net.mingsoft.people.entity.PeopleEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="peopleBiz")
public class PeopleBizImpl
extends BaseBizImpl
implements IPeopleBiz {
    @Autowired
    private IPeopleDao peopleDao;

    protected IBaseDao getDao() {
        return this.peopleDao;
    }

    @Override
    public int savePeople(PeopleEntity people) {
        this.peopleDao.saveEntity((BaseEntity)people);
        return this.saveEntity((BaseEntity)people);
    }

    @Override
    public void updatePeople(PeopleEntity people) {
        people.setPeopleAppId(BasicUtil.getAppId());
        this.peopleDao.updateEntity((BaseEntity)people);
        this.updateEntity((BaseEntity)people);
    }

    @Override
    public void deletePeople(int id) {
        this.peopleDao.deleteEntity(id);
        this.deleteEntity(id);
    }

    @Override
    public PeopleEntity getEntityByUserName(String userName, int appId) {
        return this.peopleDao.getEntityByUserName(userName, appId);
    }

    @Override
    public List<PeopleEntity> queryPageListByAppId(int appId) {
        return this.peopleDao.queryPageListByAppId(appId);
    }

    @Override
    public int queryCountByAppId(int appId) {
        return this.peopleDao.getCount(appId, null);
    }

    @Override
    public PeopleEntity getEntityByCode(String userName, String peopleCode, int appId) {
        return this.peopleDao.getEntityByCode(userName, peopleCode, appId);
    }

    @Override
    public int getCountByDate(String peopleDateTime, Integer appId) {
        HashMap<String, String> where = new HashMap<String, String>();
        where.put("peopleDateTime", peopleDateTime);
        return this.peopleDao.getCount(appId, where);
    }

    @Override
    public void deletePeople(int[] peopleIds) {
        if (peopleIds == null) {
            return;
        }
        this.peopleDao.deletePeoples(peopleIds);
        this.delete(peopleIds);
    }

    @Override
    public List<PeopleEntity> queryByAppIdAndMap(int appId, Map whereMap) {
        return this.peopleDao.queryByAppIdAndMap(appId, whereMap);
    }

    @Override
    public int getCountByAppIdAndMap(int appId, Map whereMap) {
        return this.peopleDao.getCountByAppIdAndMap(appId, whereMap);
    }

    @Override
    public PeopleEntity getByPeople(PeopleEntity people, int appId) {
        return this.peopleDao.getByPeople(people, appId);
    }

    @Override
    public PeopleEntity getEntityByMailOrPhone(String userName, int appId) {
        return this.peopleDao.getEntityByMailOrPhone(userName, appId);
    }

    @Override
    public List<PeopleEntity> query(int appId, Map where) {
        return this.peopleDao.query(appId, where);
    }
}

